/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.behavior;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DABlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="deep_aether", bus=EventBusSubscriber.Bus.GAME)
public class DABlockInteractionBehavior {
    @SubscribeEvent
    public static void bonemealEvent(BonemealEvent event) {
        if (event.getState().is(DATags.Blocks.HAS_GLOWING_SPORES)) {
            Block.popResource((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            event.getStack().consume(1, (LivingEntity)event.getPlayer());
            event.setSuccessful(true);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack = event.getItemStack();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        if (itemstack.is(Tags.Items.TOOLS_SHEAR)) {
            DABlockInteractionBehavior.handleShears(event, itemstack, pos, level, state, player);
        } else if (event.getFace() != Direction.DOWN && ((PotionContents)itemstack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) {
            DABlockInteractionBehavior.handleWatterBottle(event, itemstack, pos, level, state, player);
        } else if (itemstack.is((Item)AetherItems.SKYROOT_POISON_BUCKET.get())) {
            DABlockInteractionBehavior.handleSkyrootPoisonBucket(event, itemstack, level, player);
        }
    }

    private static void handleShears(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, BlockPos pos, Level level, BlockState state, Player player) {
        if (state.getBlock().equals(DABlocks.GLOWING_VINE.get())) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.VINE.defaultBlockState().setValue((Property)PipeBlock.UP, (Comparable)((Boolean)state.getValue((Property)PipeBlock.UP)))).setValue((Property)PipeBlock.NORTH, (Comparable)((Boolean)state.getValue((Property)PipeBlock.NORTH)))).setValue((Property)PipeBlock.EAST, (Comparable)((Boolean)state.getValue((Property)PipeBlock.EAST)))).setValue((Property)PipeBlock.SOUTH, (Comparable)((Boolean)state.getValue((Property)PipeBlock.SOUTH)))).setValue((Property)PipeBlock.WEST, (Comparable)((Boolean)state.getValue((Property)PipeBlock.WEST))), 18);
            level.playSound(player, pos, SoundEvents.BOGGED_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                itemstack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> {});
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
        } else if (state.getBlock().equals(DABlocks.TALL_GLOWING_GRASS.get()) && ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            level.setBlock(pos.below(1), (BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER), 18);
            level.setBlock(pos, (BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 18);
            level.playSound(player, pos, SoundEvents.BOGGED_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                itemstack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> {});
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
        }
    }

    private static void handleWatterBottle(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, BlockPos pos, Level level, BlockState state, Player player) {
        if (state.getBlock() == AetherBlocks.AETHER_DIRT.get()) {
            BlockState newState = ((Block)DABlocks.AETHER_MUD.get()).defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                ItemStack bottleStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.addItem(bottleStack)) {
                    Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)bottleStack);
                }
            }
            if (!level.isClientSide) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + level.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            level.playSound(player, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.PLAYERS, 0.5f, 1.0f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static void handleSkyrootPoisonBucket(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, Level level, Player player) {
        BlockHitResult blockRayTraceResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockState blockHitState = level.getBlockState(blockRayTraceResult.getBlockPos());
        if (blockRayTraceResult.getType() == HitResult.Type.MISS || blockRayTraceResult.getType() != HitResult.Type.BLOCK || blockHitState.getBlock() == Blocks.CAULDRON || !player.isShiftKeyDown() && blockHitState.hasBlockEntity() && level.getBlockEntity(blockRayTraceResult.getBlockPos()) instanceof MenuProvider) {
            event.setCancellationResult(InteractionResult.PASS);
        } else {
            BlockPos blockpos = blockRayTraceResult.getBlockPos();
            Direction direction = blockRayTraceResult.getDirection();
            BlockPos relativePos = blockpos.relative(direction);
            if (level.mayInteract(player, blockpos) && player.mayUseItemAt(relativePos, direction, itemstack)) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, relativePos, itemstack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
                if (!player.getAbilities().instabuild) {
                    player.setItemInHand(player.getUsedItemHand(), ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get())));
                }
                level.setBlockAndUpdate(relativePos, ((LiquidBlock)DABlocks.POISON_BLOCK.get()).defaultBlockState());
                level.playSound(null, relativePos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, relativePos);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
        event.setCanceled(true);
    }
}

