/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;

public class TooltipHelper {
    public static String getEnergyText(long amount) {
        if (amount < 1000L) {
            return String.valueOf(amount);
        }
        if (amount < 1000000L) {
            return TooltipHelper.getFormatted((double)amount / 1000.0) + I18n.get((String)"tooltip.oritech.thousand_abbrev", (Object[])new Object[0]);
        }
        if (amount < 1000000000L) {
            return TooltipHelper.getFormatted((double)amount / 1000000.0) + I18n.get((String)"tooltip.oritech.million_abbrev", (Object[])new Object[0]);
        }
        if (amount < 1000000000000L) {
            return TooltipHelper.getFormatted((double)amount / 1.0E9) + I18n.get((String)"tooltip.oritech.billion_abbrev", (Object[])new Object[0]);
        }
        return TooltipHelper.getFormatted((double)amount / 1.0E12) + I18n.get((String)"tooltip.oritech.trillion_abbrev", (Object[])new Object[0]);
    }

    private static String getFormatted(double number) {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ROOT);
        formatter.setMinimumFractionDigits(0);
        formatter.setMaximumFractionDigits(2);
        return formatter.format(number);
    }

    public static void addMachineTooltip(List<Component> tooltip, Block block, EntityBlock entityProvider) {
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            MachineBlockEntity machineEntity;
            BlockEntity entity = entityProvider.newBlockEntity(BlockPos.ZERO, block.defaultBlockState());
            boolean isAtomicForge = entity instanceof AtomicForgeBlockEntity;
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController multiblockController = (MultiblockMachineController)entity;
                List<Vec3i> corePositions = multiblockController.getCorePositions();
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.core_desc").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(corePositions.size())).withStyle(ChatFormatting.GOLD)));
            }
            if (entity instanceof FrameInteractionBlockEntity) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.frame_needed").withStyle(ChatFormatting.GRAY));
            }
            if (entity instanceof MachineAddonController) {
                MachineAddonController addonProvider = (MachineAddonController)entity;
                List<Vec3i> addonSlots = addonProvider.getAddonSlots();
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_desc").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(addonSlots.size())).withStyle(ChatFormatting.GOLD)));
            }
            if (entity instanceof MachineBlockEntity && (machineEntity = (MachineBlockEntity)entity).getEnergyPerTick() > 1 && !isAtomicForge) {
                int energyRate = machineEntity.getEnergyPerTick();
                if (entity instanceof UpgradableGeneratorBlockEntity) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.oritech.generator_rate_desc").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{energyRate}).withStyle(ChatFormatting.GOLD)));
                } else if (entity instanceof MachineBlockEntity) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.oritech.machine_rate_desc").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{energyRate}).withStyle(ChatFormatting.GOLD)));
                }
            } else if (entity instanceof ExpandableEnergyStorageBlockEntity) {
                ExpandableEnergyStorageBlockEntity energyStorage = (ExpandableEnergyStorageBlockEntity)entity;
                long transferRate = energyStorage.getDefaultExtractionRate();
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.energy_max_transfer").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{transferRate}).withStyle(ChatFormatting.GOLD)));
            }
            if (entity instanceof EnergyApi.BlockProvider) {
                ResourceLocation id;
                EnergyApi.BlockProvider energyProvider = (EnergyApi.BlockProvider)entity;
                String maxStorage = TooltipHelper.getEnergyText(energyProvider.getEnergyStorage(null).getCapacity());
                if (!isAtomicForge) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.oritech.machine_capacity_desc").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.oritech.energy_capacity", (Object[])new Object[]{maxStorage}).withStyle(ChatFormatting.GOLD)));
                }
                if (isAtomicForge || energyProvider instanceof DeepDrillEntity) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.oritech.needs_laser_power").withStyle(ChatFormatting.BOLD));
                }
                if (I18n.exists((String)("tooltip.oritech." + (id = BuiltInRegistries.BLOCK.getKey((Object)block)).getPath() + ".extra"))) {
                    tooltip.add((Component)Component.translatable((String)("tooltip.oritech." + id.getPath() + ".extra")).withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    public static Component getFormattedEnergyChangeTooltip(long amount, String unit) {
        String formatted = TooltipHelper.getEnergyText(amount);
        Object text = amount > 0L ? "+" + formatted : formatted;
        return Component.literal((String)text).withStyle(ChatFormatting.GOLD).append(unit).withStyle(ChatFormatting.GOLD);
    }

    public static Component getFormattedValueChangeTooltip(int amount) {
        Object text = amount > 0 ? "+" + amount : String.valueOf(amount);
        ChatFormatting color = amount > 0 ? ChatFormatting.GREEN : ChatFormatting.RED;
        return Component.literal((String)text).withStyle(color).append("%").withStyle(color);
    }
}

