/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import net.minecraft.nbt.CompoundTag;

public interface ColorableMachine {
    default public boolean supportRecoloring() {
        return true;
    }

    public ColorVariant getCurrentColor();

    public void assignColor(ColorVariant var1);

    default public ColorVariant getDefaultColor() {
        return ColorVariant.ORANGE;
    }

    default public void addColorToNbt(CompoundTag tag) {
        tag.putShort("color", (short)this.getCurrentColor().ordinal());
    }

    default public void loadColorFromNbt(CompoundTag tag) {
        if (tag.contains("color")) {
            short color = tag.getShort("color");
            this.assignColor(ColorVariant.values()[color]);
        }
    }

    public static enum ColorVariant {
        ORANGE,
        DIAMOND,
        CAMO,
        FLUXITE,
        WHITE,
        INDUSTRIAL,
        NETHERITE,
        REDSTONE,
        SCULK;

    }
}

