/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UnstableContainerItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final float scale;
    private final String name;

    public UnstableContainerItem(Item.Properties settings, float scale, String name) {
        super(settings);
        this.scale = scale;
        this.name = name;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            GeoItemRenderer<UnstableContainerItem> renderer = null;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GeoItemRenderer((GeoModel)new DefaultedBlockGeoModel(Oritech.id("models/" + UnstableContainerItem.this.name)));
                }
                this.renderer.withScale(UnstableContainerItem.this.scale);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        boolean shiftPressed = Screen.hasShiftDown();
        boolean ctrlPressed = Screen.hasControlDown();
        if (shiftPressed) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.low").withStyle(ChatFormatting.DARK_PURPLE));
            tooltip.addAll(UnstableContainerItem.getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.medium").withStyle(ChatFormatting.DARK_PURPLE));
            tooltip.addAll(UnstableContainerItem.getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.high").withStyle(ChatFormatting.DARK_PURPLE));
            tooltip.addAll(UnstableContainerItem.getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container_extra_info").withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC));
        }
        if (ctrlPressed) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.1").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.2").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.3").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.4").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.unstable_container.5").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos targetBlockPos = context.getClickedPos();
        BlockState targetBlockState = context.getLevel().getBlockState(targetBlockPos);
        float targetMultiplier = -1.0f;
        if (targetBlockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW)) {
            targetMultiplier = 0.3f;
        } else if (targetBlockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM)) {
            targetMultiplier = 1.0f;
        } else if (targetBlockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH)) {
            targetMultiplier = 5.0f;
        }
        for (Vec3i offset : UnstableContainerBlockEntity.getCoreOffsets()) {
            BlockPos worldPos = targetBlockPos.offset(offset);
            BlockState candidateState = context.getLevel().getBlockState(worldPos);
            if (candidateState.canBeReplaced() || offset.equals((Object)new Vec3i(0, -1, 0))) continue;
            context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"text.oritech.unstable_container_blocked"));
            ParticleContent.HIGHLIGHT_BLOCK.spawn(context.getLevel(), Vec3.atLowerCornerOf((Vec3i)worldPos));
            return InteractionResult.FAIL;
        }
        if (targetMultiplier > 0.0f) {
            context.getLevel().setBlockAndUpdate(targetBlockPos, BlockContent.UNSTABLE_CONTAINER.defaultBlockState());
            BlockState createdBlockState = context.getLevel().getBlockState(targetBlockPos);
            createdBlockState.getBlock().setPlacedBy(context.getLevel(), targetBlockPos, createdBlockState, (LivingEntity)context.getPlayer(), context.getItemInHand());
            UnstableContainerBlockEntity createdEntity = (UnstableContainerBlockEntity)context.getLevel().getBlockEntity(targetBlockPos, BlockEntitiesContent.UNSTABLE_CONTAINER_BLOCK_ENTITY).get();
            createdEntity.setCapturedBlock(targetBlockState);
            createdEntity.qualityMultiplier = targetMultiplier;
            Player player = context.getPlayer();
            if (!player.isCreative()) {
                ItemStack stack = context.getItemInHand();
                stack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static List<MutableComponent> getBlocksFromTag(TagKey<Block> tagKey) {
        Optional candidate = BuiltInRegistries.BLOCK.getTag(tagKey);
        if (candidate.isEmpty()) {
            return new ArrayList<MutableComponent>();
        }
        return ((HolderSet.Named)candidate.get()).stream().map(blockRegistryEntry -> ((Block)blockRegistryEntry.value()).getName().withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})).toList();
    }
}

