/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.world.features.uranium;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.joml.Vector2d;
import rearth.oritech.init.world.features.uranium.UraniumPatchFeatureConfig;
import rearth.oritech.util.Geometry;

public class UraniumPatchFeature
extends Feature<UraniumPatchFeatureConfig> {
    public UraniumPatchFeature(Codec<UraniumPatchFeatureConfig> configCodec) {
        super(configCodec);
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public boolean place(FeaturePlaceContext<UraniumPatchFeatureConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        if (world.isClientSide()) {
            return false;
        }
        BlockPos testPos = new BlockPos((Vec3i)origin.below(3));
        if (UraniumPatchFeature.isAirOrWater(world.getBlockState(testPos))) {
            this.placeStructure(testPos, context);
        }
        return false;
    }

    private void placeStructure(BlockPos pos, FeaturePlaceContext<UraniumPatchFeatureConfig> context) {
        RandomSource random = context.random();
        UraniumPatchFeatureConfig config = (UraniumPatchFeatureConfig)context.config();
        BlockState state = ((Block)BuiltInRegistries.BLOCK.get(config.blockId())).defaultBlockState();
        Block crystalBlock = (Block)BuiltInRegistries.BLOCK.get(config.crystalId());
        WorldGenLevel world = context.level();
        int range = config.number();
        BlockPos closestWall = pos;
        for (BlockPos candidate : BlockPos.withinManhattan((BlockPos)pos, (int)range, (int)range, (int)range)) {
            BlockState candidateState = world.getBlockState(candidate);
            if (UraniumPatchFeature.isAirOrWater(candidateState)) continue;
            closestWall = candidate;
            break;
        }
        if (closestWall.equals((Object)pos)) {
            return;
        }
        BlockPos closestWallDir = closestWall.subtract((Vec3i)pos);
        Vec3i forward = this.getBiggestDirection((Vec3i)closestWallDir);
        Direction facing = Direction.fromDelta((int)forward.getX(), (int)forward.getY(), (int)forward.getZ());
        if (facing == null) {
            return;
        }
        Vec3i right = Geometry.getRight(facing);
        Vec3i up = Geometry.getUp(facing);
        int veinCount = 3;
        for (int i = 0; i < veinCount; ++i) {
            Vector2d randomDir = new Vector2d((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f)).normalize();
            int veinLength = random.nextIntBetweenInclusive(5, 9);
            for (int j = 0; j < veinLength; ++j) {
                BlockPos test = pos.offset(right.multiply((int)(randomDir.x * (double)j))).offset(up.multiply((int)(randomDir.y * (double)j)));
                BlockPos test2 = pos.offset(right.multiply((int)(randomDir.x * (double)j + 0.5))).offset(up.multiply((int)(randomDir.y * (double)j + 0.5)));
                for (int k = 0; k < 5; ++k) {
                    BlockPos projected = test.offset(forward.multiply(k));
                    BlockPos projected2 = test2.offset(forward.multiply(k));
                    BlockState testState = world.getBlockState(projected);
                    BlockState testState2 = world.getBlockState(projected2);
                    if (this.isValidReplacementBloc(testState)) {
                        this.createCrystals(projected, world, random, crystalBlock);
                        world.setBlock(projected, state, 2, 0);
                        break;
                    }
                    if (!this.isValidReplacementBloc(testState2)) continue;
                    world.setBlock(projected2, state, 2, 0);
                    break;
                }
                randomDir = randomDir.add((double)random.nextFloat() * 0.2, (double)random.nextFloat() * 0.2).normalize();
            }
        }
    }

    private boolean isValidReplacementBloc(BlockState state) {
        return state.is(BlockTags.DEEPSLATE_ORE_REPLACEABLES) || state.is(BlockTags.STONE_ORE_REPLACEABLES);
    }

    private void createCrystals(BlockPos pos, WorldGenLevel world, RandomSource random, Block crystal) {
        for (BlockPos neighborPos : this.getNeighbors(pos)) {
            BlockState neighborState = world.getBlockState(neighborPos);
            boolean isValid = neighborState.isAir() || neighborState.is(Blocks.WATER);
            if (!isValid || (double)random.nextFloat() < 0.7) continue;
            boolean waterLogged = neighborState.is(Blocks.WATER);
            Direction facing = Geometry.fromVector((Vec3i)neighborPos.subtract((Vec3i)pos));
            if (facing == null) continue;
            BlockState targetState = (BlockState)((BlockState)crystal.defaultBlockState().setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged))).setValue((Property)AmethystClusterBlock.FACING, (Comparable)facing);
            world.setBlock(neighborPos, targetState, 2, 0);
        }
    }

    private List<BlockPos> getNeighbors(BlockPos pos) {
        return List.of(pos.below(), pos.above(), pos.north(), pos.east(), pos.south(), pos.west());
    }

    private Vec3i getBiggestDirection(Vec3i source) {
        int x = Math.abs(source.getX());
        int y = Math.abs(source.getY());
        int z = Math.abs(source.getZ());
        if (x > y && x > z) {
            return new Vec3i(Math.clamp((long)source.getX(), -1, 1), 0, 0);
        }
        if (y > x && y > z) {
            return new Vec3i(0, Math.clamp((long)source.getY(), -1, 1), 0);
        }
        return new Vec3i(0, 0, Math.clamp((long)source.getZ(), -1, 1));
    }
}

