/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.registries.RegistrySupplier;
import java.lang.reflect.Field;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.ItemGroups;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.item.tools.ElectricMaceItem;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.armor.BackstorageExoArmorItem;
import rearth.oritech.item.tools.armor.ExoArmorItem;
import rearth.oritech.item.tools.armor.JetpackElytraItem;
import rearth.oritech.item.tools.armor.JetpackExoArmorItem;
import rearth.oritech.item.tools.armor.JetpackExoElytraItem;
import rearth.oritech.item.tools.armor.JetpackItem;
import rearth.oritech.item.tools.harvesting.ChainsawItem;
import rearth.oritech.item.tools.harvesting.DrillItem;
import rearth.oritech.item.tools.harvesting.ElectricToolMaterial;
import rearth.oritech.item.tools.harvesting.PromethiumAxeItem;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import rearth.oritech.item.tools.harvesting.PromethiumToolMaterial;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

public class ToolsContent
implements ArchitecturyRegistryContainer<Item> {
    protected static final Item.Properties UNBREAKING_SETTINGS;
    protected static final Item.Properties ELECTRIC_SETTINGS;
    protected static final Item.Properties JETPACK_SETTINGS;
    public static final Holder<ArmorMaterial> EXOSUIT_MATERIAL;
    public static final Holder<ArmorMaterial> JETPACK_MATERIAL;
    public static final Tier ELECTRIC_MATERIAL;
    public static final Tier PROMETHIUM_MATERIAL;
    public static final Item EXO_HELMET;
    public static final Item EXO_CHESTPLATE;
    public static final Item EXO_LEGGINGS;
    public static final Item EXO_BOOTS;
    public static final Item JETPACK;
    public static final Item EXO_JETPACK;
    public static final Item JETPACK_ELYTRA;
    public static final Item JETPACK_EXO_ELYTRA;
    public static final Item PORTABLE_LASER;
    public static final Item ELECTRIC_MACE;
    public static final Item CHAINSAW;
    public static final Item HAND_DRILL;
    public static final Item PROMETHIUM_AXE;
    public static final Item PROMETHIUM_PICKAXE;

    @Override
    public ResourceKey<Registry<Item>> getRegistryType() {
        return Registries.ITEM;
    }

    @Override
    public void postProcessField(String namespace, Item value, String identifier, Field field, RegistrySupplier<Item> supplier) {
        ItemContent.Groups targetGroup = ItemContent.Groups.equipment;
        if (field.isAnnotationPresent(ItemContent.ItemGroupTarget.class)) {
            targetGroup = field.getAnnotation(ItemContent.ItemGroupTarget.class).value();
        }
        ItemGroups.add(targetGroup, (ItemLike)value);
        if (EnergyApi.ITEM != null && value instanceof OritechEnergyItem) {
            OritechEnergyItem energyItem = (OritechEnergyItem)value;
            ItemStack variantStack = new ItemStack((ItemLike)value);
            variantStack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)energyItem.getEnergyCapacity(variantStack));
            ItemGroups.add(targetGroup, variantStack);
            EnergyApi.ITEM.registerForItem(() -> value);
        }
        if (FluidApi.ITEM != null && value instanceof FluidApi.ItemProvider) {
            FluidApi.ITEM.registerForItem(() -> value);
        }
    }

    public static void registerEventHandlers() {
        BlockEvent.BREAK.register(PromethiumPickaxeItem::preMine);
        TickEvent.SERVER_LEVEL_PRE.register(PromethiumAxeItem::onTick);
        EntityEvent.LIVING_HURT.register((entity, source, amount) -> {
            if (source.typeHolder().is(DamageTypes.FALL) && entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
                if (boots == null) {
                    return EventResult.pass();
                }
                if (!(boots.getItem() instanceof ExoArmorItem)) {
                    return EventResult.pass();
                }
                player.level().playSound(null, player.blockPosition(), SoundContent.SHORT_SERVO, SoundSource.PLAYERS, 0.2f, 1.0f);
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    public Class<Item> getTargetFieldType() {
        return Item.class;
    }

    static {
        ELECTRIC_SETTINGS = UNBREAKING_SETTINGS = new Item.Properties().stacksTo(1).durability(0).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        JETPACK_SETTINGS = UNBREAKING_SETTINGS;
        EXOSUIT_MATERIAL = ArmorMaterials.IRON;
        JETPACK_MATERIAL = ArmorMaterials.LEATHER;
        ELECTRIC_MATERIAL = new ElectricToolMaterial();
        PROMETHIUM_MATERIAL = new PromethiumToolMaterial();
        EXO_HELMET = new ExoArmorItem(EXOSUIT_MATERIAL, ArmorItem.Type.HELMET, UNBREAKING_SETTINGS);
        EXO_CHESTPLATE = new BackstorageExoArmorItem(EXOSUIT_MATERIAL, ArmorItem.Type.CHESTPLATE, ELECTRIC_SETTINGS);
        EXO_LEGGINGS = new ExoArmorItem(EXOSUIT_MATERIAL, ArmorItem.Type.LEGGINGS, UNBREAKING_SETTINGS);
        EXO_BOOTS = new ExoArmorItem(EXOSUIT_MATERIAL, ArmorItem.Type.BOOTS, UNBREAKING_SETTINGS);
        JETPACK = new JetpackItem(JETPACK_MATERIAL, ArmorItem.Type.CHESTPLATE, JETPACK_SETTINGS);
        EXO_JETPACK = new JetpackExoArmorItem(EXOSUIT_MATERIAL, ArmorItem.Type.CHESTPLATE, JETPACK_SETTINGS);
        JETPACK_ELYTRA = new JetpackElytraItem(JETPACK_MATERIAL, ArmorItem.Type.CHESTPLATE, JETPACK_SETTINGS);
        JETPACK_EXO_ELYTRA = new JetpackExoElytraItem(EXOSUIT_MATERIAL, ArmorItem.Type.CHESTPLATE, JETPACK_SETTINGS);
        PORTABLE_LASER = new PortableLaserItem(UNBREAKING_SETTINGS);
        ELECTRIC_MACE = new ElectricMaceItem(UNBREAKING_SETTINGS.attributes(ElectricMaceItem.createAttributes()).rarity(Rarity.EPIC));
        CHAINSAW = new ChainsawItem(ELECTRIC_MATERIAL, ELECTRIC_SETTINGS.attributes(AxeItem.createAttributes((Tier)ELECTRIC_MATERIAL, (float)5.0f, (float)-2.4f)));
        HAND_DRILL = new DrillItem(ELECTRIC_MATERIAL, TagContent.DRILL_MINEABLE, ELECTRIC_SETTINGS.attributes(PickaxeItem.createAttributes((Tier)ELECTRIC_MATERIAL, (float)1.0f, (float)-2.4f)));
        PROMETHIUM_AXE = new PromethiumAxeItem(PROMETHIUM_MATERIAL, UNBREAKING_SETTINGS.attributes(PromethiumPickaxeItem.createPromethiumAttributes(PROMETHIUM_MATERIAL, 12.0f, -2.1f, 2.0f)));
        PROMETHIUM_PICKAXE = new PromethiumPickaxeItem(PROMETHIUM_MATERIAL, TagContent.DRILL_MINEABLE, UNBREAKING_SETTINGS.attributes(PromethiumPickaxeItem.createPromethiumAttributes(PROMETHIUM_MATERIAL, 3.0f, -2.4f, 2.0f)));
    }
}

