/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CustomBlockComponent
extends BaseComponent {
    private final Minecraft client = Minecraft.getInstance();
    private final BlockState state;
    @Nullable
    private final BlockEntity entity;

    public CustomBlockComponent(BlockState state, @Nullable BlockEntity entity) {
        this.state = state;
        this.entity = entity;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        context.pose().pushPose();
        context.pose().translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f - (float)this.height * 0.15f, 100.0f);
        context.pose().scale((float)(40 * this.width) / 64.0f, (float)(-40 * this.height) / 64.0f, 40.0f);
        context.pose().scale(1.3f, 1.3f, 1.3f);
        context.pose().mulPose(Axis.XP.rotationDegrees(-30.0f));
        context.pose().mulPose(Axis.YP.rotationDegrees(180.0f));
        context.pose().mulPose(Axis.ZP.rotationDegrees(45.0f));
        context.pose().translate(-0.5, -0.5, -0.5);
        RenderSystem.runAsFancy(() -> {
            MultiBufferSource.BufferSource vertexConsumers = this.client.renderBuffers().bufferSource();
            if (this.state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                this.client.getBlockRenderer().renderSingleBlock(this.state, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            vertexConsumers.endBatch();
        });
        context.pose().popPose();
    }
}

