/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.MachineAddonController;

public class UpgradableMachineScreenHandler
extends BasicMachineScreenHandler {
    protected final Level worldAccess;
    protected final MachineAddonController addonController;

    public UpgradableMachineScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.player.level().getBlockEntity(buf.readBlockPos())));
    }

    public UpgradableMachineScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(syncId, playerInventory, blockEntity);
        if (blockEntity instanceof MachineAddonController) {
            MachineAddonController upgradableEntity;
            this.addonController = upgradableEntity = (MachineAddonController)blockEntity;
        } else {
            Oritech.LOGGER.debug("Creating Upgrade screen for non-upgradable block: {}", (Object)blockEntity);
            this.addonController = null;
        }
        this.worldAccess = playerInventory.player.level();
    }

    @Override
    public boolean showRedstoneAddon() {
        return super.showRedstoneAddon() || this.addonController.getConnectedAddons().stream().anyMatch(addonPos -> this.worldAccess.getBlockState(addonPos).getBlock().equals(BlockContent.MACHINE_REDSTONE_ADDON));
    }
}

