/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SpriteComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.ui.util.SpriteUtilInvoker;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import rearth.oracle.OracleClient;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.generators.BasicGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.client.renderers.LaserArmModel;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.TooltipHelper;

public class BasicMachineScreen<S extends BasicMachineScreenHandler>
extends BaseOwoHandledScreen<FlowLayout, S> {
    public static final ResourceLocation BACKGROUND = Oritech.id("textures/gui/modular/gui_base.png");
    public static final ResourceLocation ITEM_SLOT = Oritech.id("textures/gui/modular/itemslot.png");
    public static final ResourceLocation GUI_COMPONENTS = Oritech.id("textures/gui/modular/machine_gui_components.png");
    public static final int GRAY_TEXT_COLOR = new Color(0.2f, 0.2f, 0.3f).rgb();
    public static Surface ORITECH_PANEL = (context, component) -> NinePatchTexture.draw((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORITECH_PANEL_DARK = (context, component) -> NinePatchTexture.draw((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_dark"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORITECH_PANEL_ORANGE = (context, component) -> NinePatchTexture.draw((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_orange"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static ButtonComponent.Renderer ORITECH_BUTTON = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        ResourceLocation texture = button.active ? (button.isHovered() ? (Minecraft.getInstance().mouseHandler.isLeftPressed() ? ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_pressed") : ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_hover")) : ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw((ResourceLocation)texture, (OwoUIDrawContext)matrices, (int)button.getX(), (int)button.getY(), (int)button.width(), (int)button.height());
    };
    public static ButtonComponent.Renderer ORITECH_BUTTON_DARK = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        ResourceLocation texture = button.active ? (button.isHovered() ? (Minecraft.getInstance().mouseHandler.isLeftPressed() ? ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_pressed") : ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_dark_hover")) : ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"bedrock_panel_dark")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw((ResourceLocation)texture, (OwoUIDrawContext)matrices, (int)button.getX(), (int)button.getY(), (int)button.width(), (int)button.height());
    };
    public FlowLayout root;
    protected TextureComponent progress_indicator;
    protected TextureComponent energyIndicator;
    private ButtonComponent cycleInputButton;
    private final FluidDisplay genericDisplay;
    private final FluidDisplay steamDisplay;
    private final FluidDisplay waterDisplay;
    protected final LabelComponent steamProductionLabel;

    public BasicMachineScreen(S handler, Inventory inventory, net.minecraft.network.chat.Component title) {
        super(handler, inventory, title);
        ScreenProvider.BarConfiguration config;
        if (((BasicMachineScreenHandler)((Object)handler)).mainFluidContainer != null) {
            config = ((BasicMachineScreenHandler)((Object)handler)).screenData.getFluidConfiguration();
            this.genericDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).mainFluidContainer, config);
        } else {
            this.genericDisplay = null;
        }
        if (((BasicMachineScreenHandler)((Object)handler)).steamStorage != null) {
            config = this.getBoilerInConfig();
            this.waterDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).waterStorage, config);
            ScreenProvider.BarConfiguration configSteam = this.getBoilerOutConfig();
            this.steamDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).steamStorage, configSteam);
            this.steamProductionLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"title.oritech.steam_production", (Object[])new Object[]{"0"}));
            this.steamProductionLabel.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.steam_production"));
        } else {
            this.steamDisplay = null;
            this.waterDisplay = null;
            this.steamProductionLabel = null;
        }
    }

    public ScreenProvider.BarConfiguration getBoilerInConfig() {
        return ((BasicMachineScreenHandler)this.menu).screenData.getEnergyConfiguration();
    }

    public ScreenProvider.BarConfiguration getBoilerOutConfig() {
        ScreenProvider.BarConfiguration config = this.getBoilerInConfig();
        return new ScreenProvider.BarConfiguration(config.x() + config.width() + 8, config.y(), config.width(), config.height());
    }

    public ResourceLocation getGuiComponents() {
        return GUI_COMPONENTS;
    }

    public ResourceLocation getItemSlot() {
        return ITEM_SLOT;
    }

    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    protected FluidDisplay initFluidDisplay(FluidApi.SingleSlotStorage container, ScreenProvider.BarConfiguration config) {
        float lastFill = 1.0f - (float)container.getStack().getAmount() / (float)container.getCapacity();
        ColoredSpriteComponent background = BasicMachineScreen.createFluidRenderer(container.getStack(), config);
        BoxComponent fillOverlay = Components.box((Sizing)Sizing.fixed((int)config.width()), (Sizing)Sizing.fixed((int)((int)((float)config.height() * lastFill))));
        fillOverlay.color(new Color(0.30431372f, 0.30431372f, 0.30431372f));
        fillOverlay.fill(true);
        fillOverlay.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        TextureComponent foreGround = Components.texture((ResourceLocation)this.getGuiComponents(), (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
        foreGround.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        foreGround.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        return new FluidDisplay(fillOverlay, lastFill, container.getStack().getFluid(), background, foreGround, config, container);
    }

    public static Component getItemFrame(int x, int y) {
        return Components.texture((ResourceLocation)ITEM_SLOT, (int)0, (int)0, (int)18, (int)18, (int)18, (int)18).sizing(Sizing.fixed((int)18)).positioning(Positioning.absolute((int)(x - 1), (int)(y - 1)));
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.root = rootComponent;
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        if (this.showExtensionPanel()) {
            rootComponent.child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)426), (Sizing)Sizing.fixed((int)206)).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.buildExtensionPanel()).surface(ORITECH_PANEL).positioning(Positioning.absolute((int)293, (int)30))).positioning(Positioning.relative((int)50, (int)50)).zIndex(-1));
        }
        if (((BasicMachineScreenHandler)this.menu).armorSlots != null) {
            rootComponent.child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)426), (Sizing)Sizing.fixed((int)206)).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.buildEquipmentPanel()).surface(ORITECH_PANEL).positioning(Positioning.absolute((int)96, (int)30))).positioning(Positioning.relative((int)50, (int)50)).zIndex(-1));
        }
        if (Oritech.CONFIG.enableHelpButton()) {
            boolean hasOracleLib = Platform.isModLoaded((String)"oracle_index");
            Optional<Object> linkTarget = hasOracleLib ? this.getHelpBookLink() : Optional.empty();
            ButtonComponent oracleButton = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"?"), elem -> this.onOracleButtonClick(hasOracleLib, linkTarget));
            oracleButton.renderer(ORITECH_BUTTON_DARK);
            if (hasOracleLib) {
                oracleButton.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.oracle_available"));
            } else {
                oracleButton.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.oracle_missing"));
            }
            oracleButton.positioning(Positioning.relative((int)0, (int)96));
            oracleButton.zIndex(10);
            if (linkTarget.isPresent() || !hasOracleLib) {
                rootComponent.child((Component)Containers.horizontalFlow((Sizing)Sizing.fixed((int)201), (Sizing)Sizing.fixed((int)186)).child((Component)oracleButton).positioning(Positioning.relative((int)50, (int)50)));
            }
        }
        rootComponent.child((Component)Components.texture((ResourceLocation)BACKGROUND, (int)0, (int)0, (int)176, (int)166, (int)176, (int)166)).child((Component)this.buildOverlay().positioning(Positioning.relative((int)50, (int)50)));
    }

    public boolean showExtensionPanel() {
        return ((BasicMachineScreenHandler)this.menu).screenData.showExpansionPanel();
    }

    protected void containerTick() {
        super.containerTick();
        if (((BasicMachineScreenHandler)this.menu).screenData.showEnergy()) {
            if (((BasicMachineScreenHandler)this.menu).steamStorage != null) {
                this.updateFluidDisplay(this.waterDisplay);
                this.updateFluidDisplay(this.steamDisplay);
            } else {
                this.updateEnergyBar();
            }
        }
        if (((BasicMachineScreenHandler)this.menu).screenData.showProgress()) {
            this.updateProgressBar();
        }
        if (this.showExtensionPanel()) {
            this.updateSettingsButtons();
        }
        if (((BasicMachineScreenHandler)this.menu).mainFluidContainer != null) {
            this.updateFluidDisplay(this.genericDisplay);
        }
        if (this.steamProductionLabel != null) {
            float productionRate = ((BasicMachineScreenHandler)this.menu).screenData.getDisplayedEnergyUsage() * Oritech.CONFIG.generators.steamEngineData.rfToSteamRatio();
            productionRate = Math.min((float)this.waterDisplay.storage.getStack().getAmount(), productionRate);
            this.steamProductionLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"title.oritech.steam_production", (Object[])new Object[]{String.format("%.0f", Float.valueOf(productionRate))}));
        }
    }

    private void updateProgressBar() {
        MachineBlockEntity machineEntity;
        ScreenProvider.ArrowConfiguration config = ((BasicMachineScreenHandler)this.menu).screenData.getIndicatorConfiguration();
        float progress = ((BasicMachineScreenHandler)this.menu).screenData.getProgress();
        BlockEntity blockEntity = ((BasicMachineScreenHandler)this.menu).blockEntity;
        if (blockEntity instanceof MachineBlockEntity && ((machineEntity = (MachineBlockEntity)blockEntity).getCurrentRecipe().getTime() > 0 || machineEntity.progress > 0)) {
            int progressTicks = machineEntity.progress;
            int recipeDurationTicks = machineEntity.getCurrentRecipe().getTime();
            int effectiveDurationTicks = (int)((float)recipeDurationTicks * machineEntity.getSpeedMultiplier());
            if (machineEntity instanceof UpgradableGeneratorBlockEntity) {
                UpgradableGeneratorBlockEntity generatorBlock = (UpgradableGeneratorBlockEntity)machineEntity;
                if (recipeDurationTicks <= 0) {
                    recipeDurationTicks = (int)((float)generatorBlock.currentMaxBurnTime / generatorBlock.getSpeedMultiplier() * generatorBlock.getEfficiencyMultiplier());
                }
                effectiveDurationTicks = generatorBlock.currentMaxBurnTime;
            }
            if (machineEntity instanceof BasicGeneratorEntity) {
                BasicGeneratorEntity generatorEntity = (BasicGeneratorEntity)machineEntity;
                recipeDurationTicks = generatorEntity.currentMaxBurnTime;
            }
            this.progress_indicator.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.progress_indicator", (Object[])new Object[]{progressTicks, effectiveDurationTicks, recipeDurationTicks}));
        }
        if (config.horizontal()) {
            this.progress_indicator.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)((int)((float)config.width() * progress)), (int)config.height()));
        } else {
            this.progress_indicator.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)config.width(), (int)((int)((float)config.height() * progress))));
        }
    }

    protected void updateEnergyBar() {
        long capacity = ((BasicMachineScreenHandler)this.menu).energyStorage.getCapacity();
        long amount = ((BasicMachineScreenHandler)this.menu).energyStorage.getAmount();
        long transfer = (long)((BasicMachineScreenHandler)this.menu).screenData.getDisplayedEnergyTransfer();
        long usage = (long)((BasicMachineScreenHandler)this.menu).screenData.getDisplayedEnergyUsage();
        float fillAmount = (float)amount / (float)capacity;
        net.minecraft.network.chat.Component tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, usage, transfer);
        boolean isAtomicForge = ((BasicMachineScreenHandler)this.menu).blockEntity instanceof AtomicForgeBlockEntity;
        if (isAtomicForge) {
            tooltipText = tooltipText.plainCopy().append((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.atomic_forge_energy_tip"));
        }
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }

    public static net.minecraft.network.chat.Component getEnergyTooltip(long amount, long max, long showedUsage, long showedTransfer) {
        float percentage = (float)amount / (float)max;
        String energyFill = String.format("%.1f", Float.valueOf(percentage * 100.0f));
        String storedAmount = TooltipHelper.getEnergyText(amount);
        String usageText = TooltipHelper.getEnergyText(showedUsage);
        String maxAmount = TooltipHelper.getEnergyText(max);
        String transfer = TooltipHelper.getEnergyText(showedTransfer);
        return net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.energy_usage", (Object[])new Object[]{storedAmount, maxAmount, energyFill, usageText, transfer});
    }

    public void updateSettingsButtons() {
        BlockEntity blockEntity;
        InventoryInputMode activeMode = ((BasicMachineScreenHandler)this.menu).screenData.getInventoryInputMode();
        String modeName = activeMode.name().toLowerCase(Locale.ROOT);
        if (activeMode.equals((Object)InventoryInputMode.SIDED) && (blockEntity = ((BasicMachineScreenHandler)this.menu).blockEntity) instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)blockEntity;
            MutableComponent tooltip = net.minecraft.network.chat.Component.translatable((String)"tooltip.%s.input_mode_%s".formatted("oritech", modeName));
            InventorySlotAssignment assignment = machineBlock.getSlotAssignments();
            for (Direction direction : Direction.values()) {
                String key = "tooltip.oritech.mode_sided_slot_number";
                if (direction.equals((Object)Direction.DOWN)) {
                    key = "tooltip.oritech.mode_sided_bottom";
                }
                if (direction.equals((Object)Direction.UP)) {
                    key = "tooltip.oritech.mode_sided_top";
                }
                int horizontalOrdinal = 0;
                if (direction.equals((Object)Direction.EAST)) {
                    horizontalOrdinal = 1;
                }
                if (direction.equals((Object)Direction.SOUTH)) {
                    horizontalOrdinal = 2;
                }
                if (direction.equals((Object)Direction.WEST)) {
                    horizontalOrdinal = 3;
                }
                int inputSlotIndex = assignment.inputStart() + horizontalOrdinal % assignment.inputCount();
                tooltip = tooltip.append((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)key, (Object[])new Object[]{StringUtils.capitalize((String)direction.toString()), inputSlotIndex}));
            }
            this.cycleInputButton.tooltip((net.minecraft.network.chat.Component)tooltip);
        } else {
            this.cycleInputButton.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.%s.input_mode_%s".formatted("oritech", modeName)));
        }
        this.cycleInputButton.setMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"button.%s.input_mode_%s".formatted("oritech", modeName)).withColor(GRAY_TEXT_COLOR));
        this.cycleInputButton.setMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"button.%s.input_mode_%s".formatted("oritech", modeName)).withColor(GRAY_TEXT_COLOR));
    }

    private Component buildExtensionPanel() {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        container.padding(Insets.of((int)1, (int)4, (int)1, (int)1));
        container.margins(Insets.of((int)7));
        this.addExtensionComponents(container);
        this.updateSettingsButtons();
        return container;
    }

    private Component buildEquipmentPanel() {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        container.padding(Insets.of((int)2));
        container.margins(Insets.of((int)6));
        for (int i = ((BasicMachineScreenHandler)this.menu).armorSlots.size() - 1; i >= 0; --i) {
            Integer slotId = ((BasicMachineScreenHandler)this.menu).armorSlots.get(i);
            FlowLayout slotContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            BaseOwoHandledScreen.SlotComponent slotComponent = this.slotAsComponent(slotId);
            TextureComponent background = Components.texture((ResourceLocation)this.getEquipmentSlotTexture(i), (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
            slotContainer.child((Component)slotComponent);
            slotContainer.child((Component)background.positioning(Positioning.absolute((int)0, (int)0)));
            container.child((Component)slotContainer.margins(Insets.of((int)1)));
            if (i <= 0) continue;
            container.child((Component)Components.box((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)));
        }
        return container;
    }

    private ResourceLocation getEquipmentSlotTexture(int armorSlot) {
        return switch (armorSlot) {
            case 0 -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/empty_armor_slot_boots.png");
            case 1 -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/empty_armor_slot_leggings.png");
            case 2 -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/empty_armor_slot_chestplate.png");
            case 3 -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/empty_armor_slot_helmet.png");
            case 4 -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/empty_slot_axe.png");
            default -> null;
        };
    }

    public void addExtensionComponents(FlowLayout container) {
        this.cycleInputButton = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"button.oritech.input_mode_fill_matching_recipe").withColor(GRAY_TEXT_COLOR), button -> NetworkManager.sendToServer(new MachineBlockEntity.InventoryInputModeSelectorPacket(((BasicMachineScreenHandler)this.menu).blockPos)));
        this.cycleInputButton.horizontalSizing(Sizing.fixed((int)73));
        this.cycleInputButton.margins(Insets.of((int)3));
        this.cycleInputButton.renderer(ORITECH_BUTTON);
        this.cycleInputButton.textShadow(false);
        container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"title.oritech.details")).margins(Insets.of((int)3, (int)1, (int)1, (int)1)));
        long inputSlots = ((BasicMachineScreenHandler)this.menu).screenData.getGuiSlots().stream().filter(slot -> !slot.output()).count();
        if (((BasicMachineScreenHandler)this.menu).screenData.inputOptionsEnabled() && inputSlots > 1L) {
            container.child((Component)this.cycleInputButton);
        }
        for (Tuple<net.minecraft.network.chat.Component, net.minecraft.network.chat.Component> label : ((BasicMachineScreenHandler)this.menu).screenData.getExtraExtensionLabels()) {
            container.child(Components.label((net.minecraft.network.chat.Component)((net.minecraft.network.chat.Component)label.getA())).tooltip((net.minecraft.network.chat.Component)label.getB()).margins(Insets.of((int)3)));
        }
        if (((BasicMachineScreenHandler)this.menu).showRedstoneAddon()) {
            container.child((Component)Components.box((Sizing)Sizing.fixed((int)73), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)).margins(Insets.of((int)2)));
            boolean hasRedstone = ((BasicMachineScreenHandler)this.menu).screenData.receivedRedstoneSignal() > 0;
            FlowLayout statusContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            statusContainer.child(Components.block((BlockState)((BlockState)Blocks.REDSTONE_TORCH.defaultBlockState().setValue((Property)RedstoneTorchBlock.LIT, (Comparable)Boolean.valueOf(hasRedstone)))).sizing(Sizing.fixed((int)20)).margins(Insets.of((int)-6, (int)-4, (int)-8, (int)-4)));
            statusContainer.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.redstone_power", (Object[])new Object[]{((BasicMachineScreenHandler)this.menu).screenData.receivedRedstoneSignal()})).margins(Insets.of((int)3, (int)1, (int)1, (int)1)));
            container.child((Component)statusContainer);
            if (!((BasicMachineScreenHandler)this.menu).screenData.currentRedstoneEffect().isEmpty()) {
                container.child(Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)((BasicMachineScreenHandler)this.menu).screenData.currentRedstoneEffect())).tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)(((BasicMachineScreenHandler)this.menu).screenData.currentRedstoneEffect() + ".tooltip"))).margins(Insets.of((int)3, (int)3, (int)1, (int)1)));
            }
        }
    }

    private FlowLayout buildOverlay() {
        FlowLayout overlay = Containers.verticalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)166));
        this.fillOverlay(overlay);
        return overlay;
    }

    public void fillOverlay(FlowLayout overlay) {
        this.addTitle(overlay);
        if (((BasicMachineScreenHandler)this.menu).mainFluidContainer != null) {
            this.addFluidDisplay(overlay, this.genericDisplay);
            this.updateFluidDisplay(this.genericDisplay);
        }
        for (ScreenProvider.GuiSlot slot : ((BasicMachineScreenHandler)this.menu).screenData.getGuiSlots()) {
            overlay.child((Component)this.slotAsComponent(slot.index()).positioning(Positioning.absolute((int)slot.x(), (int)slot.y())));
            overlay.child(BasicMachineScreen.getItemFrame(slot.x(), slot.y()));
        }
        if (((BasicMachineScreenHandler)this.menu).screenData.showEnergy()) {
            if (((BasicMachineScreenHandler)this.menu).steamStorage != null) {
                this.addFluidDisplay(overlay, this.steamDisplay);
                this.updateFluidDisplay(this.steamDisplay);
                this.addFluidDisplay(overlay, this.waterDisplay);
                this.updateFluidDisplay(this.waterDisplay);
            } else {
                this.addEnergyBar(overlay);
                this.updateEnergyBar();
            }
            if (((BasicMachineScreenHandler)this.menu).blockEntity instanceof SteamEngineEntity) {
                this.addEnergyBar(overlay);
                this.updateEnergyBar();
            }
        }
        if (((BasicMachineScreenHandler)this.menu).screenData.showProgress()) {
            this.addProgressArrow(overlay);
            this.updateProgressBar();
        }
    }

    private void onOracleButtonClick(boolean enabled, Optional<ResourceLocation> target) {
        if (!enabled || target.isEmpty()) {
            Oritech.LOGGER.info("Oracle Index mod is missing. Install it here: https://www.curseforge.com/minecraft/mc-mods/oracle-index (or from modrinth)");
            return;
        }
        OracleClient.openScreen((String)"oritech", (ResourceLocation)target.get(), (Screen)this);
    }

    private Optional<ResourceLocation> getHelpBookLink() {
        if (((BasicMachineScreenHandler)this.menu).screenData.getWikiLink().isPresent()) {
            return Optional.of(ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)("books/oritech/" + ((BasicMachineScreenHandler)this.menu).screenData.getWikiLink().get() + ".mdx")));
        }
        Item blockItem = ((BasicMachineScreenHandler)this.menu).machineBlock.getBlock().asItem();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)blockItem);
        if (OracleClient.ITEM_LINKS.containsKey(itemId)) {
            return Optional.of(((OracleClient.BookItemLink)OracleClient.ITEM_LINKS.get(itemId)).linkTarget());
        }
        return Optional.empty();
    }

    public boolean useHighTitle() {
        return ((BasicMachineScreenHandler)this.menu).machineBlock.getBlock().getName().toString().length() > 18;
    }

    private void addTitle(FlowLayout overlay) {
        MutableComponent blockTitle = ((BasicMachineScreenHandler)this.menu).machineBlock.getBlock().getName();
        LabelComponent label = Components.label((net.minecraft.network.chat.Component)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.zIndex(1);
        ItemComponent blockIcon = Components.item((ItemStack)this.getTitleIcon());
        blockIcon.sizing(Sizing.fixed((int)24));
        FlowLayout iconPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        iconPanel.padding(Insets.of((int)2, (int)5, (int)3, (int)3));
        iconPanel.child((Component)blockIcon);
        iconPanel.surface(ORITECH_PANEL);
        iconPanel.zIndex(50);
        FlowLayout textPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        textPanel.padding(Insets.of((int)5, (int)6, (int)6, (int)5));
        textPanel.child((Component)label);
        textPanel.surface(ORITECH_PANEL);
        FlowLayout combinedPanel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        combinedPanel.child((Component)iconPanel);
        combinedPanel.child((Component)textPanel.margins(Insets.of((int)4, (int)0, (int)-1, (int)0)));
        int horizontalPos = blockTitle.getString().length() > 15 ? 100 : 65;
        int verticalPos = this.useHighTitle() ? -25 : -15;
        overlay.child((Component)combinedPanel.positioning(Positioning.relative((int)horizontalPos, (int)verticalPos)));
        overlay.allowOverflow(true);
    }

    public ItemStack getTitleIcon() {
        return new ItemStack((ItemLike)((BasicMachineScreenHandler)this.menu).blockEntity.getBlockState().getBlock());
    }

    private void addProgressArrow(FlowLayout panel) {
        ScreenProvider.ArrowConfiguration config = ((BasicMachineScreenHandler)this.menu).screenData.getIndicatorConfiguration();
        TextureComponent empty = Components.texture((ResourceLocation)config.empty(), (int)0, (int)0, (int)config.width(), (int)config.height(), (int)config.width(), (int)config.height());
        this.progress_indicator = Components.texture((ResourceLocation)config.full(), (int)0, (int)0, (int)config.width(), (int)config.height(), (int)config.width(), (int)config.height());
        panel.child((Component)empty.positioning(Positioning.absolute((int)config.x(), (int)config.y()))).child((Component)this.progress_indicator.positioning(Positioning.absolute((int)config.x(), (int)config.y())));
    }

    protected void addFluidDisplay(FlowLayout panel, FluidDisplay display) {
        panel.child((Component)display.background);
        panel.child((Component)display.fillOverlay);
        panel.child((Component)display.foreGround);
    }

    protected void updateFluidDisplay(FluidDisplay display) {
        float targetFill;
        ColoredSpriteComponent background = display.background;
        FluidApi.SingleSlotStorage container = display.storage;
        ScreenProvider.BarConfiguration config = display.config;
        if (!display.lastDrawnFluid.equals(container.getStack().getFluid())) {
            ParentComponent parent = background.parent();
            int targetIndex = parent.children().indexOf((Object)background);
            ColoredSpriteComponent newFluid = BasicMachineScreen.createFluidRenderer(container.getStack(), config);
            parent.removeChild((Component)background);
            ((FlowLayout)parent).child(targetIndex, (Component)newFluid);
            display.background = background = newFluid;
            display.lastDrawnFluid = container.getStack().getFluid();
        }
        float fill = 1.0f - (float)container.getStack().getAmount() / (float)container.getCapacity();
        display.lastFill = targetFill = LaserArmModel.lerp(display.lastFill, fill, 0.15f);
        display.fillOverlay.verticalSizing(Sizing.fixed((int)((int)((float)config.height() * targetFill * 0.98f))));
        MutableComponent tooltipText = container.getStack().getAmount() > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{container.getStack().getAmount() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)container.getStack()).getString()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
        background.tooltip((net.minecraft.network.chat.Component)tooltipText);
    }

    public static ColoredSpriteComponent createFluidRenderer(FluidStack stack, ScreenProvider.BarConfiguration config) {
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((FluidStack)stack);
        int spriteColor = FluidStackHooks.getColor((FluidStack)stack);
        Color parsedColor = Color.ofArgb((int)spriteColor);
        Color opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1.0f);
        spriteColor = opaqueColor.argb();
        return BasicMachineScreen.getColoredSpriteComponent(stack, config, sprite, spriteColor);
    }

    @NotNull
    private static ColoredSpriteComponent getColoredSpriteComponent(FluidStack stack, ScreenProvider.BarConfiguration config, TextureAtlasSprite sprite, int spriteColor) {
        MutableComponent tooltipText = stack.getAmount() > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{stack.getAmount() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)stack).toString()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
        ColoredSpriteComponent result = new ColoredSpriteComponent(sprite);
        result.widthMultiplier = (float)config.width() / 60.0f;
        result.color = Color.ofArgb((int)spriteColor);
        result.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        result.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        result.tooltip((net.minecraft.network.chat.Component)tooltipText);
        return result;
    }

    private void addEnergyBar(FlowLayout panel) {
        ScreenProvider.BarConfiguration config = ((BasicMachineScreenHandler)this.menu).screenData.getEnergyConfiguration();
        int insetSize = 1;
        MutableComponent tooltipText = net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{0, 50});
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(config.width() + insetSize * 2)), (Sizing)Sizing.fixed((int)(config.height() + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        frame.positioning(Positioning.absolute((int)(config.x() - insetSize), (int)(config.y() - insetSize)));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((ResourceLocation)this.getGuiComponents(), (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator = Components.texture((ResourceLocation)this.getGuiComponents(), (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((net.minecraft.network.chat.Component)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    protected static final class FluidDisplay {
        private final BoxComponent fillOverlay;
        private float lastFill;
        private Fluid lastDrawnFluid;
        protected ColoredSpriteComponent background;
        private final TextureComponent foreGround;
        private final ScreenProvider.BarConfiguration config;
        private final FluidApi.SingleSlotStorage storage;

        private FluidDisplay(BoxComponent fillOverlay, float lastFill, Fluid lastDrawnFluid, ColoredSpriteComponent background, TextureComponent foreGround, ScreenProvider.BarConfiguration config, FluidApi.SingleSlotStorage storage) {
            this.fillOverlay = fillOverlay;
            this.lastFill = lastFill;
            this.lastDrawnFluid = lastDrawnFluid;
            this.background = background;
            this.foreGround = foreGround;
            this.config = config;
            this.storage = storage;
        }
    }

    public static class ColoredSpriteComponent
    extends SpriteComponent {
        public Color color;
        public float widthMultiplier = 1.0f;

        protected ColoredSpriteComponent(TextureAtlasSprite sprite) {
            super(sprite);
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (this.sprite == null) {
                return;
            }
            SpriteUtilInvoker.markSpriteActive((TextureAtlasSprite)this.sprite);
            this.drawSprite(this.x, this.y, 0, this.width, this.height, this.sprite, this.color.red(), this.color.green(), this.color.blue(), this.color.alpha(), context.pose());
        }

        public void drawSprite(int x, int y, int z, int width, int height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha, PoseStack matrices) {
            float uvWidth = sprite.getU1() - sprite.getU0();
            float newMax = sprite.getU0() + uvWidth * this.widthMultiplier;
            this.drawTexturedQuad(sprite.atlasLocation(), matrices, x, x + width, y, y + height, z, sprite.getU0(), newMax, sprite.getV0(), sprite.getV1(), red, green, blue, alpha);
        }

        private void drawTexturedQuad(ResourceLocation texture, PoseStack matrices, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.enableBlend();
            Matrix4f matrix4f = matrices.last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)z).setUv(u1, v1).setColor(red, green, blue, alpha);
            bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)z).setUv(u1, v2).setColor(red, green, blue, alpha);
            bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(red, green, blue, alpha);
            bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)z).setUv(u2, v1).setColor(red, green, blue, alpha);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }
}

