/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BeamRenderer {
    public static int color(int r, int g, int b, int a) {
        return a * 255 << 24 | r * 255 << 16 | g * 255 << 8 | b * 255;
    }

    public static void renderStraightBeam(PoseStack poseStack, VertexConsumer consumer, Vec3 startPos, Vec3 delta, float thickness, int packedLight, int startColor, int endColor) {
        poseStack.pushPose();
        poseStack.translate(startPos.x, startPos.y, startPos.z);
        double xzDist = Math.sqrt(delta.x * delta.x + delta.z * delta.z);
        float yRot = (float)(-Mth.atan2((double)(-delta.x), (double)delta.z));
        float xRot = (float)(-Mth.atan2((double)delta.y, (double)xzDist));
        poseStack.mulPose(Axis.YP.rotation(yRot));
        poseStack.mulPose(Axis.XP.rotation(xRot + 1.5707964f));
        float length = (float)delta.length();
        float r = thickness;
        int a1 = startColor >> 24 & 0xFF;
        int r1 = startColor >> 16 & 0xFF;
        int g1 = startColor >> 8 & 0xFF;
        int b1 = startColor & 0xFF;
        int a2 = endColor >> 24 & 0xFF;
        int r2 = endColor >> 16 & 0xFF;
        int g2 = endColor >> 8 & 0xFF;
        int b2 = endColor & 0xFF;
        PoseStack.Pose pose = poseStack.last();
        BeamRenderer.addVertex(consumer, pose, -r, 0.0f, r, r1, g1, b1, a1, 0.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, 0.0f, r, r1, g1, b1, a1, 1.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, length, r, r2, g2, b2, a2, 1.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, length, r, r2, g2, b2, a2, 0.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, 0.0f, -r, r1, g1, b1, a1, 0.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, 0.0f, -r, r1, g1, b1, a1, 1.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, length, -r, r2, g2, b2, a2, 1.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, length, -r, r2, g2, b2, a2, 0.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, 0.0f, -r, r1, g1, b1, a1, 0.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, 0.0f, r, r1, g1, b1, a1, 1.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, length, r, r2, g2, b2, a2, 1.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, -r, length, -r, r2, g2, b2, a2, 0.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, 0.0f, r, r1, g1, b1, a1, 0.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, 0.0f, -r, r1, g1, b1, a1, 1.0f, 1.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, length, -r, r2, g2, b2, a2, 1.0f, 0.0f, packedLight);
        BeamRenderer.addVertex(consumer, pose, r, length, r, r2, g2, b2, a2, 0.0f, 0.0f, packedLight);
        poseStack.popPose();
    }

    private static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int r, int g, int b, int a, float u, float v, int packedLight) {
        consumer.addVertex(pose.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

