/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.client.renderers.PortableLaserModel;
import rearth.oritech.client.renderers.util.BeamRenderer;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.PortableLaserItem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class PortableLaserRenderer
extends GeoItemRenderer<PortableLaserItem> {
    public PortableLaserRenderer(String modelName) {
        super((GeoModel)new PortableLaserModel(Oritech.id("models/" + modelName)));
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    public void postRender(PoseStack matrices, PortableLaserItem animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ItemStack heldStack = client.player.getMainHandItem();
        ClientLevel world = client.level;
        if (isReRender || !this.renderPerspective.firstPerson()) {
            return;
        }
        long singleShotAge = world.getGameTime() - PortableLaserItem.lastSingleShot;
        if (!OritechClient.laserActive && singleShotAge > 10L) {
            return;
        }
        if (!heldStack.getItem().equals(ToolsContent.PORTABLE_LASER)) {
            return;
        }
        if (animatable.getStoredEnergy(heldStack) < (long)Oritech.CONFIG.portableLaserConfig.energyPerTick()) {
            return;
        }
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(0.0f);
        Vec3 endPos = startPos.add(lookVec.scale(128.0));
        HitResult hit = PortableLaserItem.getPlayerTargetRay((Player)player);
        if (hit != null && hit.getType().equals((Object)HitResult.Type.MISS)) {
            endPos = hit.getLocation();
        }
        float dist = (float)endPos.distanceTo(startPos);
        matrices.pushPose();
        Vec3 localStart = new Vec3(0.0, 0.05, 0.0);
        Vec3 deltaVec = new Vec3(0.0, 0.0, (double)(-dist));
        VertexConsumer beamConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)LaserArmRenderer.BEAM_TEXTURE));
        float baseThickness = (float)((double)0.03f + Math.sin(((float)world.getGameTime() + partialTick) * 1.1f) * (double)0.01f);
        BeamRenderer.renderStraightBeam(matrices, beamConsumer, localStart, deltaVec, baseThickness * 0.3f, 0xF000F0, LaserArmRenderer.CORE_COLOR_START, LaserArmRenderer.CORE_COLOR_END);
        BeamRenderer.renderStraightBeam(matrices, beamConsumer, localStart, deltaVec, baseThickness, 0xF000F0, -1718947105, -1726784688);
        matrices.popPose();
    }
}

