/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.client.renderers.MachineModel;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class MachineRenderer<T extends BlockEntity>
extends GeoBlockRenderer<T> {
    public MachineRenderer(String modelPath) {
        super(new MachineModel(modelPath));
    }

    public MachineRenderer(String modelPath, boolean glowing) {
        super(new MachineModel(modelPath));
        if (glowing) {
            this.addRenderLayer((GeoRenderLayer)new CustomGlowingGeoLayer(this));
        }
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        if (facing.equals((Object)Direction.UP)) {
            poseStack.translate(0.0, 0.5, -0.5);
        } else if (facing.equals((Object)Direction.DOWN)) {
            poseStack.translate(0.0, 0.5, 0.5);
        }
        super.rotateBlock(facing, poseStack);
    }

    public AABB getRenderBoundingBox(BlockEntity blockEntity) {
        return AABB.ofSize((Vec3)blockEntity.getBlockPos().getCenter(), (double)4.0, (double)4.0, (double)4.0);
    }

    public static class CustomGlowingGeoLayer<T extends BlockEntity>
    extends AutoGlowingGeoLayer<T> {
        public CustomGlowingGeoLayer(GeoRenderer<T> renderer) {
            super(renderer);
        }

        @Nullable
        protected RenderType getRenderType(T animatable, @Nullable MultiBufferSource bufferSource) {
            GeoModel geoModel = this.renderer.getGeoModel();
            if (geoModel instanceof MachineModel) {
                MachineModel machineModel = (MachineModel)geoModel;
                ResourceLocation basePath = machineModel.getBaseTexturePath(animatable);
                ResourceLocation path = GeoAbstractTexture.appendToPath((ResourceLocation)basePath, (String)"_glowmask");
                return AutoGlowingTexture.getRenderType((ResourceLocation)path);
            }
            return AutoGlowingTexture.getRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
        }
    }
}

