/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;

public class ZiplineSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;

    public ZiplineSoundInstance(Player player) {
        super(SoundEvents.MINECART_RIDING, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.1f;
        this.pitch = 0.5f;
        this.relative = false;
    }

    public void tick() {
        if (!ClientZiplineHandler.isZiplining(this.player) || this.player.isRemoved()) {
            this.stop();
            return;
        }
        this.x = this.player.getX();
        this.y = this.player.getY() + 2.0;
        this.z = this.player.getZ();
        float speed = (float)this.player.getDeltaMovement().length();
        float targetPitch = (float)Mth.clamp((double)(speed / 1.5f), (double)0.5, (double)1.8);
        float targetVolume = (float)Mth.clamp((double)((double)speed * 0.6), (double)0.0, (double)0.8);
        this.pitch = Mth.lerp((float)0.35f, (float)this.pitch, (float)targetPitch);
        this.volume = Mth.lerp((float)0.35f, (float)this.volume, (float)targetVolume);
    }
}

