/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.cablesurfer.CableMath;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.ServerZiplineHandler;

public class ClientZiplineHandler {
    private static boolean active = false;
    private static Vec3 startPos;
    private static Vec3 endPos;
    private static Vec3 parallelStart;
    private static Vec3 parallelEnd;
    private static float progress;
    private static float currentSpeed;
    private static double totalDistance;
    public static final float HANG_OFFSET = 1.65f;
    private static final float DRAG = 0.97f;
    private static final float GRAVITY_FORCE = 0.1f;
    private static CameraType previousCamera;

    public static Vec3 getStartPos() {
        return startPos;
    }

    public static Vec3 getEndPos() {
        return endPos;
    }

    public static Vec3 getParallelStart() {
        return parallelStart;
    }

    public static Vec3 getParallelEnd() {
        return parallelEnd;
    }

    public static boolean isZiplining(Player player) {
        return AttachmentApi.getAttachmentValue((LivingEntity)player, ServerZiplineHandler.ZIPLINING_STATE);
    }

    public static void start(Vec3 start, Vec3 end, Vec3 parStart, Vec3 parEnd, float initialSpeed) {
        if (active) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        active = true;
        startPos = start;
        endPos = end;
        totalDistance = start.distanceTo(end);
        parallelStart = parStart;
        parallelEnd = parEnd;
        Vec3 searchPos = player.position().add(0.0, (double)1.65f, 0.0);
        progress = ClientZiplineHandler.calculateClosestProgress(start, end, searchPos);
        Vec3 cableDir = endPos.subtract(startPos).normalize();
        Vec3 lookDir = player.getLookAngle();
        currentSpeed = initialSpeed;
        if (cableDir.dot(lookDir) < 0.0) {
            currentSpeed = -initialSpeed;
        }
        if (currentSpeed == 0.0f) {
            currentSpeed = 0.15f;
        }
        if ((previousCamera = Minecraft.getInstance().options.getCameraType()) == CameraType.FIRST_PERSON && Oritech.CONFIG.ziplineCameraSwitch()) {
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
        }
        Vec3 ropePos = CableMath.getAt(startPos, endPos, progress);
        Vec3 initialPos = ropePos.add(0.0, (double)-1.65f, 0.0);
        player.setPos(initialPos.x, initialPos.y, initialPos.z);
        player.setDeltaMovement(player.getLookAngle().scale((double)currentSpeed));
    }

    private static float calculateClosestProgress(Vec3 start, Vec3 end, Vec3 targetPos) {
        double bestDistSq = Double.MAX_VALUE;
        float bestT = 0.0f;
        int steps = (int)start.distanceTo(end) + 1;
        for (int i = 0; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            Vec3 pointOnWire = CableMath.getAt(start, end, t);
            double distSq = pointOnWire.distanceToSqr(targetPos);
            if (!(distSq < bestDistSq)) continue;
            bestDistSq = distSq;
            bestT = t;
        }
        return bestT;
    }

    public static void onClientTick() {
        Vec3 lookDir;
        if (!active) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isAlive() || !player.getMainHandItem().is(ItemContent.WRENCH)) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        NetworkManager.sendToServer(new ServerZiplineHandler.ZiplinePlayerUsePacket());
        if (player.input.shiftKeyDown) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        if (player.input.jumping) {
            ClientZiplineHandler.dismount(true);
            return;
        }
        int directionMultiplier = 1;
        Vec3 cableDir = endPos.subtract(startPos).normalize();
        if (cableDir.dot(lookDir = player.getLookAngle()) < 0.0) {
            directionMultiplier = -1;
        }
        float maxSpeed = Oritech.CONFIG.maxZiplineSpeed();
        float acceleration = Oritech.CONFIG.ziplineAcceleration();
        if (player.input.up) {
            currentSpeed += acceleration * (float)directionMultiplier;
        } else if (player.input.down) {
            currentSpeed -= acceleration * (float)directionMultiplier;
        }
        float t = progress;
        float tNext = Mth.clamp((float)(t + 0.01f), (float)0.0f, (float)1.01f);
        Vec3 p1 = CableMath.getAt(startPos, endPos, t);
        Vec3 p2 = CableMath.getAt(startPos, endPos, tNext);
        Vec3 tangent = p2.subtract(p1).normalize();
        double slopeY = tangent.y;
        currentSpeed -= (float)(slopeY * (double)0.1f);
        currentSpeed *= 0.97f;
        currentSpeed = Mth.clamp((float)currentSpeed, (float)(-maxSpeed), (float)maxSpeed);
        float progressDelta = (float)((double)currentSpeed / totalDistance);
        progress += progressDelta;
        if (progress >= 1.0f) {
            progress = 1.0f;
            ClientZiplineHandler.dismount(true);
            return;
        }
        if (progress <= 0.0f) {
            progress = 0.0f;
            currentSpeed = 0.0f;
            ClientZiplineHandler.dismount(true);
        }
        Vec3 ropePos = CableMath.getAt(startPos, endPos, progress);
        Vec3 nextPlayerPos = ropePos.add(0.0, (double)-1.65f, 0.0);
        if ((double)Math.abs(currentSpeed) > 0.6 && Oritech.CONFIG.ziplineAutoJump()) {
            double dynamicEjectDist;
            double blocksRemaining = (double)(1.0f - progress) * totalDistance;
            if (directionMultiplier < 0) {
                blocksRemaining = (double)progress * totalDistance;
            }
            if (blocksRemaining < (dynamicEjectDist = 1.5 + (double)(Math.abs(currentSpeed) * 3.0f))) {
                ClientZiplineHandler.dismount(false);
                Vec3 currentVel = player.getDeltaMovement();
                player.setPos(nextPlayerPos.x, nextPlayerPos.y + 1.0, nextPlayerPos.z);
                player.setDeltaMovement(currentVel.x * 1.2, (currentVel.y > 0.0 ? currentVel.y * 1.2 : 0.0) + 0.7, currentVel.z * 1.2);
                ClientZiplineHandler.playWooshSound((Player)player);
                return;
            }
        }
        Vec3 oldPos = player.position();
        Vec3 velocity = nextPlayerPos.subtract(oldPos);
        AABB bounds = player.getDimensions(Pose.STANDING).makeBoundingBox(nextPlayerPos);
        bounds = bounds.deflate(0.1);
        if (!player.level().noCollision((Entity)player, bounds)) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        player.setPos(nextPlayerPos.x, nextPlayerPos.y, nextPlayerPos.z);
        player.setDeltaMovement(velocity);
        player.fallDistance = 0.0f;
    }

    private static void dismount(boolean jump) {
        LocalPlayer player;
        active = false;
        if (previousCamera != null && Oritech.CONFIG.ziplineCameraSwitch()) {
            Minecraft.getInstance().options.setCameraType(previousCamera);
        }
        if ((player = Minecraft.getInstance().player) != null) {
            if (jump) {
                Vec3 currentVel = player.getDeltaMovement();
                Vec3 playerPos = player.getPosition(0.0f);
                player.setPos(playerPos.x, playerPos.y + 1.0, playerPos.z);
                player.setDeltaMovement(currentVel.x * 1.5, currentVel.y() * (double)1.2f + 0.6, currentVel.z * 1.5);
                ClientZiplineHandler.playWooshSound((Player)player);
            } else {
                player.playSound(SoundEvents.IRON_TRAPDOOR_CLOSE, 0.5f, 1.5f);
            }
            Vec3 gustPos = player.getPosition(0.0f);
            RandomSource random = player.level().random;
            Vec3 gustVel = player.getDeltaMovement();
            player.level().addParticle((ParticleOptions)ParticleTypes.GUST, gustPos.x, gustPos.y + 0.3, gustPos.z, gustVel.x + (double)random.nextFloat() * 0.3, gustVel.y + (double)random.nextFloat() * 0.3, gustVel.z + (double)random.nextFloat() * 0.3);
        }
    }

    private static void playWooshSound(Player player) {
        player.playSound(SoundEvents.BAT_TAKEOFF, 2.0f, 2.0f);
    }
}

