/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.client.cablesurfer.CableMath;

public class ClientCableFinder {
    private static final boolean DEBUG_DRAW = false;
    private static final int POLE_SEARCH_RADIUS = 196;

    public static CableHit findLookedAtCable(Player player, float reachDistance) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookDir = player.getViewVector(1.0f).normalize();
        BlockPos minPos = BlockPos.containing((Position)eyePos.add(-196.0, -196.0, -196.0));
        BlockPos maxPos = BlockPos.containing((Position)eyePos.add(196.0, 196.0, 196.0));
        ArrayList<PowerPoleEntity> nearbyPoles = new ArrayList<PowerPoleEntity>();
        for (int cx = minPos.getX() >> 4; cx <= maxPos.getX() >> 4; ++cx) {
            for (int cz = minPos.getZ() >> 4; cz <= maxPos.getZ() >> 4; ++cz) {
                if (!level.hasChunk(cx, cz)) continue;
                for (BlockEntity be : level.getChunk(cx, cz).getBlockEntities().values()) {
                    PowerPoleEntity pole;
                    if (!(be instanceof PowerPoleEntity) || !(player.distanceToSqr(Vec3.atCenterOf((Vec3i)(pole = (PowerPoleEntity)be).getBlockPos())) < 38416.0)) continue;
                    nearbyPoles.add(pole);
                }
            }
        }
        double bestDistSq = Double.MAX_VALUE;
        CableHit bestHit = null;
        Vec3 debugHitPos = null;
        for (PowerPoleEntity startPole : nearbyPoles) {
            BlockPos startPos = startPole.getBlockPos();
            Vec3 startCenter = Vec3.atCenterOf((Vec3i)startPos);
            Direction startFacing = startPole.getFacingForMultiblock();
            Vec3 startSideVec = Vec3.atLowerCornerOf((Vec3i)startFacing.getNormal());
            for (PowerPoleEntity.ConnectionTarget target : startPole.getConnections()) {
                RayResult result2;
                Vec3 cable2End;
                Vec3 cable2Start;
                Vec3 cable1End;
                Vec3 cable1Start;
                double distCross;
                BlockPos endPos = target.pos();
                Vec3 endCenter = Vec3.atCenterOf((Vec3i)endPos);
                Direction endFacing = target.facing();
                Vec3 endSideVec = Vec3.atLowerCornerOf((Vec3i)endFacing.getNormal());
                if (!ClientCableFinder.isPlayerNearCableBounds(player, startCenter, endCenter, reachDistance)) continue;
                Vec3 startWorldA = startCenter.add(startSideVec);
                Vec3 startWorldB = startCenter.subtract(startSideVec);
                Vec3 targetWorldA = endCenter.add(endSideVec);
                Vec3 targetWorldB = endCenter.subtract(endSideVec);
                double distDirect = startWorldA.distanceToSqr(targetWorldA) + startWorldB.distanceToSqr(targetWorldB);
                if (distDirect < (distCross = startWorldA.distanceToSqr(targetWorldB) + startWorldB.distanceToSqr(targetWorldA))) {
                    cable1Start = startWorldA;
                    cable1End = targetWorldA;
                    cable2Start = startWorldB;
                    cable2End = targetWorldB;
                } else {
                    cable1Start = startWorldA;
                    cable1End = targetWorldB;
                    cable2Start = startWorldB;
                    cable2End = targetWorldA;
                }
                RayResult result1 = ClientCableFinder.raycastCable(cable1Start, cable1End, eyePos, lookDir, reachDistance, (Level)level);
                if (result1 != null && result1.distSq < bestDistSq) {
                    bestDistSq = result1.distSq;
                    bestHit = new CableHit(startPos, endPos, cable1Start, cable1End, cable2Start, cable2End);
                    debugHitPos = result1.hitPos;
                }
                if ((result2 = ClientCableFinder.raycastCable(cable2Start, cable2End, eyePos, lookDir, reachDistance, (Level)level)) == null || !(result2.distSq < bestDistSq)) continue;
                bestDistSq = result2.distSq;
                bestHit = new CableHit(startPos, endPos, cable2Start, cable2End, cable1Start, cable1End);
                debugHitPos = result2.hitPos;
            }
        }
        return bestHit;
    }

    private static boolean isPlayerNearCableBounds(Player player, Vec3 start, Vec3 end, float reach) {
        double minX = Math.min(start.x, end.x) - (double)reach;
        double minY = Math.min(start.y, end.y) - (double)reach - 10.0;
        double minZ = Math.min(start.z, end.z) - (double)reach;
        double maxX = Math.max(start.x, end.x) + (double)reach;
        double maxY = Math.max(start.y, end.y) + (double)reach;
        double maxZ = Math.max(start.z, end.z) + (double)reach;
        Vec3 p = player.position();
        return p.x >= minX && p.x <= maxX && p.y >= minY && p.y <= maxY && p.z >= minZ && p.z <= maxZ;
    }

    private static RayResult raycastCable(Vec3 p1, Vec3 p2, Vec3 eyePos, Vec3 lookDir, float reach, Level level) {
        double cableLength = p1.distanceTo(p2);
        int segments = Mth.clamp((int)((int)cableLength), (int)8, (int)128);
        double hitRadius = 1.5;
        double hitRadiusSq = hitRadius * hitRadius;
        double reachSq = reach * reach;
        Vec3 prevPoint = CableMath.getAt(p1, p2, 0.0f);
        RayResult bestLocal = null;
        double bestLocalDist = Double.MAX_VALUE;
        for (int i = 1; i <= segments; ++i) {
            double distToPlayer;
            float t = (float)i / (float)segments;
            Vec3 nextPoint = CableMath.getAt(p1, p2, t);
            Vec3 closestOnSeg = ClientCableFinder.getClosestPointOnSegment(prevPoint, nextPoint, eyePos, lookDir);
            if (ClientCableFinder.distSqPointToRay(closestOnSeg, eyePos, lookDir) < hitRadiusSq && (distToPlayer = eyePos.distanceToSqr(closestOnSeg)) < reachSq && distToPlayer < bestLocalDist) {
                bestLocalDist = distToPlayer;
                bestLocal = new RayResult(distToPlayer, closestOnSeg);
            }
            prevPoint = nextPoint;
        }
        return bestLocal;
    }

    private static Vec3 getClosestPointOnSegment(Vec3 segA, Vec3 segB, Vec3 rayOrigin, Vec3 rayDir) {
        Vec3 u = rayDir;
        Vec3 v = segB.subtract(segA);
        Vec3 w = rayOrigin.subtract(segA);
        double a = u.dot(u);
        double b = u.dot(v);
        double c = v.dot(v);
        double d = u.dot(w);
        double e = v.dot(w);
        double D = a * c - b * b;
        double tc = D < 1.0E-8 ? (b > c ? d / b : e / c) : (a * e - b * d) / D;
        return segA.add(v.scale(Mth.clamp((double)tc, (double)0.0, (double)1.0)));
    }

    private static double distSqPointToRay(Vec3 point, Vec3 rayOrigin, Vec3 rayDir) {
        Vec3 w = point.subtract(rayOrigin);
        double proj = w.dot(rayDir);
        if (proj < 0.0) {
            proj = 0.0;
        }
        return point.distanceToSqr(rayOrigin.add(rayDir.scale(proj)));
    }

    private record RayResult(double distSq, Vec3 hitPos) {
    }

    public record CableHit(BlockPos poleA, BlockPos poleB, Vec3 selectedStart, Vec3 selectedEnd, Vec3 parallelStart, Vec3 parallelEnd) {
    }
}

