/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;
import rearth.oritech.client.renderers.PowerPoleCableRenderer;

public class ActiveCableRenderer {
    public static void render(PoseStack poseStack, MultiBufferSource bufferSource) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && !ClientZiplineHandler.isZiplining((Player)player)) {
            return;
        }
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        Vec3 start = ClientZiplineHandler.getStartPos();
        Vec3 end = ClientZiplineHandler.getEndPos();
        Vec3 parStart = ClientZiplineHandler.getParallelStart();
        Vec3 parEnd = ClientZiplineHandler.getParallelEnd();
        if (start == null || end == null) {
            return;
        }
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)PowerPoleCableRenderer.CABLE_TEXTURE));
        ActiveCableRenderer.renderHangingCable(poseStack, consumer, start.subtract(camPos), end.subtract(camPos), 0.048f);
        if (parStart != null && parEnd != null) {
            ActiveCableRenderer.renderHangingCable(poseStack, consumer, parStart.subtract(camPos), parEnd.subtract(camPos), 0.048f);
        }
    }

    private static void renderHangingCable(PoseStack poseStack, VertexConsumer consumer, Vec3 startPos, Vec3 endPos, float thickness) {
        Vec3 totalOffset = endPos.subtract(startPos);
        float totalLength = (float)totalOffset.length();
        int segments = Mth.clamp((int)((int)totalLength), (int)8, (int)48);
        float sag = Math.min(totalLength * 0.05f, 4.0f);
        Vec3 currentPos = startPos;
        for (int i = 0; i < segments; ++i) {
            float t = (float)(i + 1) / (float)segments;
            Vec3 nextPos = startPos.add(totalOffset.scale((double)t));
            float sagY = -sag * 4.0f * t * (1.0f - t);
            nextPos = nextPos.add(0.0, (double)sagY, 0.0);
            Vec3 segmentDelta = nextPos.subtract(currentPos);
            ActiveCableRenderer.drawSegment(poseStack, consumer, currentPos, segmentDelta, thickness);
            currentPos = nextPos;
        }
    }

    private static void drawSegment(PoseStack poseStack, VertexConsumer consumer, Vec3 startPos, Vec3 delta, float thickness) {
        poseStack.pushPose();
        poseStack.translate(startPos.x, startPos.y, startPos.z);
        poseStack.translate(0.0f, 0.35f, 0.0f);
        double xzLen = Math.sqrt(delta.x * delta.x + delta.z * delta.z);
        float yRot = (float)(-Math.atan2(-delta.x, delta.z));
        float xRot = (float)(-Math.atan2(delta.y, xzLen));
        poseStack.mulPose(Axis.YP.rotation(yRot));
        poseStack.mulPose(Axis.XP.rotation(xRot + 1.5707964f));
        float length = (float)delta.length() * 1.02f;
        float r = thickness;
        int light = 0xF000F0;
        Matrix4f pose = poseStack.last().pose();
        Matrix3f normal = poseStack.last().normal();
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, 0.0f, r, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, 0.0f, r, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, length, r, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, length, r, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, 0.0f, -r, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, 0.0f, -r, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, length, -r, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, length, -r, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, 0.0f, -r, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, 0.0f, r, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, length, r, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, -r, length, -r, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, 0.0f, r, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, 0.0f, -r, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, length, -r, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, light);
        ActiveCableRenderer.addVertex(consumer, pose, normal, r, length, r, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, light);
        poseStack.popPose();
    }

    private static void addVertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normalMatrix, float x, float y, float z, float u, float v, float nx, float ny, float nz, int light) {
        Vector3f n = new Vector3f(nx, ny, nz);
        n.mul((Matrix3fc)normalMatrix);
        consumer.addVertex(pose, x, y, z).setColor(50, 50, 50, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(n.x, n.y, n.z);
    }
}

