/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;

public class PowerPoleEntity
extends NetworkedBlockEntity
implements MultiblockMachineController,
ExtendedMenuProvider,
ScreenProvider,
EnergyApi.BlockProvider {
    public static final HashMap<ResourceLocation, PoleNetworkData> POLE_NETWORK_DATA = new HashMap();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.INITIAL, SyncType.CUSTOM})
    private final Set<ConnectionTarget> connections = new HashSet<ConnectionTarget>();
    private PoleNetworkData netDataRef = null;
    @SyncField(value={SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats = DynamicStatisticEnergyStorage.EnergyStatistics.EMPTY;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final PowerPoleEnergyStorage energyStorage = new PowerPoleEnergyStorage();
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }

        @Override
        public long insert(long amount, boolean simulate) {
            return 0L;
        }
    };
    private final SimpleInventoryStorage basicInv = new SimpleInventoryStorage(0, this::setChanged);

    public PowerPoleEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.POWER_POLE_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        DynamicStatisticEnergyStorage.EnergyStatistics stats;
        long moved;
        this.outputEnergy();
        this.energyStorage.tick(world.getGameTime());
        if (world.random.nextFloat() > 0.95f && (moved = (stats = this.energyStorage.getCurrentStatistics(world.getGameTime())).insertedLastTickTotal() + stats.extractedLastTickTotal()) > 10L && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 at = this.worldPosition.getCenter().add((double)world.random.nextFloat() * 0.4, (double)world.random.nextFloat() * 0.4, (double)world.random.nextFloat() * 0.4);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, at.x, at.y, at.z, 2, (double)world.random.nextFloat(), (double)world.random.nextFloat(), (double)world.random.nextFloat(), (double)0.15f);
        }
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.level.getGameTime());
    }

    private void outputEnergy() {
        if (!this.isConnected() || this.energyStorage.getAmount() <= 0L) {
            return;
        }
        Tuple<Direction, BlockPos> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(this.worldPosition, this.getFacingForMultiblock().getCounterClockWise());
        EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getB(), ((Direction)target.getA()).getOpposite());
        if (candidate != null && candidate.supportsInsertion()) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    public void assignNewTarget(BlockPos target, Player player) {
        Oritech.LOGGER.info("Assigning new power pole target");
        BlockState targetState = this.level.getBlockState(target);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue()) {
            target = MachineCoreBlock.getControllerPos((LevelAccessor)this.level, target);
        }
        float pitch = 0.85f + this.level.random.nextFloat() * 0.3f;
        this.level.playSound(null, this.worldPosition, SoundContent.ELECTRIC_SHOCK, SoundSource.PLAYERS, 0.7f, pitch);
        int dist = target.distManhattan((Vec3i)this.worldPosition);
        if (dist < Oritech.CONFIG.poleConfig.minRange() || dist > Oritech.CONFIG.poleConfig.maxRange()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.pole_dist_invalid", (Object[])new Object[]{Oritech.CONFIG.poleConfig.minRange(), Oritech.CONFIG.poleConfig.maxRange(), dist}));
            return;
        }
        Optional targetEntityCandidate = this.level.getBlockEntity(target, BlockEntitiesContent.POWER_POLE_ENTITY);
        if (targetEntityCandidate.isEmpty() || target.equals((Object)this.worldPosition)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.pole_position_invalid"));
            return;
        }
        PowerPoleEntity targetEntity = (PowerPoleEntity)targetEntityCandidate.get();
        if (this.connections.stream().anyMatch(elem -> elem.pos().equals((Object)targetEntity.worldPosition))) {
            this.removeIncomingConnection(target);
            targetEntity.removeIncomingConnection(this.worldPosition);
            PoleNetworkData netData = this.getCachedNetData();
            PoleNetwork net = netData.getNetwork(this.worldPosition);
            this.updateConnectionsInState(net);
            targetEntity.updateConnectionsInState(net);
            netData.updateNetworkSplit(Set.of(this.worldPosition, target), this.getNetwork());
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.removing_pole_connection"));
            return;
        }
        this.connections.add(targetEntity.getConnectionData());
        targetEntity.assignIncomingConnection(this);
        PoleNetworkData allNetworks = this.getCachedNetData();
        PoleNetwork ownNet = this.getNetwork();
        boolean isConnected = this.isConnected();
        PoleNetwork targetNet = targetEntity.getNetwork();
        boolean targetConnected = targetEntity.isConnected();
        if (!isConnected && targetConnected) {
            this.joinNetwork(targetNet, allNetworks);
        } else if (isConnected && !targetConnected) {
            targetEntity.joinNetwork(ownNet, allNetworks);
        } else if (!isConnected && !targetConnected) {
            PoleNetwork newNet = this.createNetwork(allNetworks);
            this.joinNetwork(newNet, allNetworks);
            targetEntity.joinNetwork(newNet, allNetworks);
        } else if (isConnected && targetConnected) {
            if (targetNet != ownNet) {
                allNetworks.mergeNetworks(ownNet, targetNet);
            }
        } else {
            throw new IllegalStateException("This should never happen");
        }
        allNetworks.setDirty();
        this.updateConnectionsInState(Objects.requireNonNull(this.getNetwork()));
        targetEntity.updateConnectionsInState(this.getNetwork());
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
        player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.connected_poles"));
    }

    private void joinNetwork(PoleNetwork target, PoleNetworkData data) {
        data.activeNetworks.put(this.worldPosition, target);
    }

    private void updateConnectionsInState(PoleNetwork network) {
        network.setPole(this.worldPosition, this.connections);
    }

    private PoleNetwork createNetwork(PoleNetworkData data) {
        return new PoleNetwork();
    }

    public void assignIncomingConnection(PowerPoleEntity from) {
        this.connections.add(from.getConnectionData());
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
    }

    public void removeIncomingConnection(BlockPos source) {
        List<ConnectionTarget> removed = this.connections.stream().filter(elem -> elem.pos().equals((Object)source)).toList();
        removed.forEach(this.connections::remove);
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
    }

    public ConnectionTarget getConnectionData() {
        return new ConnectionTarget(this.worldPosition, this.getFacingForMultiblock());
    }

    public Set<ConnectionTarget> getConnections() {
        return this.connections;
    }

    public PoleNetworkData getCachedNetData() {
        if (this.netDataRef == null) {
            this.netDataRef = POLE_NETWORK_DATA.computeIfAbsent(this.level.dimension().location(), data -> new PoleNetworkData());
        }
        return this.netDataRef;
    }

    public void onRemoved() {
        for (ConnectionTarget target : this.connections) {
            BlockEntity blockEntity = this.level.getBlockEntity(target.pos);
            if (!(blockEntity instanceof PowerPoleEntity)) continue;
            PowerPoleEntity powerPole = (PowerPoleEntity)blockEntity;
            powerPole.removeIncomingConnection(this.worldPosition);
        }
        PoleNetworkData allNetworks = this.getCachedNetData();
        allNetworks.removePole(this.worldPosition);
        allNetworks.setDirty();
        this.setChanged(false);
    }

    @Override
    public void setChanged(boolean updateComparator) {
        super.setChanged(updateComparator);
        this.getCachedNetData().setDirty();
    }

    private boolean isConnected() {
        return this.getNetwork() != null;
    }

    private PoleNetwork getNetwork() {
        return this.getCachedNetData().getNetwork(this.worldPosition);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.addMultiblockToNbt(tag);
        ListTag connectionList = new ListTag();
        for (ConnectionTarget connection : this.connections) {
            CompoundTag compound = new CompoundTag();
            compound.putLong("p", connection.pos().asLong());
            compound.putInt("d", connection.facing.ordinal());
            connectionList.add((Object)compound);
        }
        tag.put("connectionData", (Tag)connectionList);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadMultiblockNbtData(tag);
        if (tag.contains("connectionData")) {
            this.connections.clear();
            ListTag nbtList = tag.getList("connectionData", 10);
            for (Tag nbtElem : nbtList) {
                CompoundTag elem = (CompoundTag)nbtElem;
                BlockPos pos = BlockPos.of((long)elem.getLong("p"));
                Direction dir = Direction.values()[elem.getInt("d")];
                this.connections.add(new ConnectionTarget(pos, dir));
            }
        }
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new UpgradableMachineScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        if (direction != null && direction.equals((Object)this.getFacingForMultiblock().getCounterClockWise())) {
            return this.outputStorage;
        }
        return this.energyStorage;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0));
    }

    @Override
    public Direction getFacingForMultiblock() {
        return ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return Oritech.CONFIG.poleConfig.energyCapacity();
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 6, 18, 72);
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.basicInv;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.POWER_POLE_SCREEN;
    }

    public static class PoleNetworkData
    extends SavedData {
        private final Map<BlockPos, PoleNetwork> activeNetworks = new HashMap<BlockPos, PoleNetwork>();
        public static SavedData.Factory<PoleNetworkData> TYPE = new SavedData.Factory(PoleNetworkData::new, PoleNetworkData::fromNbt, null);

        @NotNull
        public PoleNetwork getNetwork(BlockPos pos) {
            return this.activeNetworks.computeIfAbsent(pos, elem -> {
                HashMap<BlockPos, Set<BlockPos>> data = new HashMap<BlockPos, Set<BlockPos>>();
                data.put((BlockPos)elem, Set.of());
                return new PoleNetwork(data, 0L);
            });
        }

        @NotNull
        public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
            ListTag networksList = new ListTag();
            HashSet<PoleNetwork> uniqueNetworks = new HashSet<PoleNetwork>(this.activeNetworks.values());
            for (PoleNetwork network : uniqueNetworks) {
                CompoundTag networkCompound = new CompoundTag();
                networkCompound.putLong("energy", network.storedEnergy);
                ListTag poleList = new ListTag();
                for (Map.Entry<BlockPos, Set<BlockPos>> polePair : network.poles.entrySet()) {
                    CompoundTag data = new CompoundTag();
                    data.putLong("pos", polePair.getKey().asLong());
                    data.putLongArray("cons", polePair.getValue().stream().mapToLong(BlockPos::asLong).toArray());
                    poleList.add((Object)data);
                }
                networkCompound.put("poles", (Tag)poleList);
                networksList.add((Object)networkCompound);
            }
            tag.put("networks", (Tag)networksList);
            return tag;
        }

        public static PoleNetworkData fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
            PoleNetworkData data = new PoleNetworkData();
            if (!nbt.contains("networks")) {
                return data;
            }
            ListTag networksList = nbt.getList("networks", 10);
            for (Tag networkTag : networksList) {
                CompoundTag tag = (CompoundTag)networkTag;
                long energy = tag.getLong("energy");
                HashMap<BlockPos, Set<BlockPos>> poles = new HashMap<BlockPos, Set<BlockPos>>();
                ListTag poleDataList = tag.getList("poles", 10);
                for (Tag poleDataTag : poleDataList) {
                    CompoundTag poleData = (CompoundTag)poleDataTag;
                    BlockPos polePos = BlockPos.of((long)poleData.getLong("pos"));
                    HashSet<BlockPos> poleConnections = new HashSet<BlockPos>(Arrays.stream(poleData.getLongArray("cons")).mapToObj(BlockPos::of).toList());
                    poles.put(polePos, poleConnections);
                }
                PoleNetwork network = new PoleNetwork(poles, energy);
                for (BlockPos polePos : network.getPoles()) {
                    data.activeNetworks.put(polePos, network);
                }
            }
            return data;
        }

        protected void mergeNetworks(PoleNetwork netA, PoleNetwork netB) {
            netA.storedEnergy = Math.min(Oritech.CONFIG.poleConfig.energyCapacity(), netA.storedEnergy + netB.storedEnergy);
            netA.poles.putAll(netB.poles);
            for (BlockPos polePos : netB.getPoles()) {
                this.activeNetworks.put(polePos, netA);
            }
        }

        public void updateNetworkSplit(Set<BlockPos> removedConnections, PoleNetwork existingNet) {
            HashSet<Map<BlockPos, Set<BlockPos>>> newNets = new HashSet<Map<BlockPos, Set<BlockPos>>>();
            for (BlockPos deletedConnection : removedConnections) {
                Map<BlockPos, Set<BlockPos>> newConnectionNet = PoleNetworkData.FloodFillNetwork(existingNet, deletedConnection);
                newNets.add(newConnectionNet);
            }
            if (newNets.size() == 1) {
                return;
            }
            int newNetCount = newNets.size();
            long newNetPower = existingNet.storedEnergy / (long)newNetCount;
            for (Map map : newNets) {
                PoleNetwork newNet = new PoleNetwork(map, newNetPower);
                for (BlockPos polePos : newNet.getPoles()) {
                    this.activeNetworks.put(polePos, newNet);
                }
            }
        }

        public void removePole(BlockPos removeAt) {
            PoleNetwork existingNet = this.activeNetworks.get(removeAt);
            if (existingNet == null) {
                return;
            }
            this.activeNetworks.remove(removeAt);
            Set<BlockPos> removedPoleConnections = existingNet.poles.remove(removeAt);
            if (removedPoleConnections.size() <= 1) {
                return;
            }
            this.updateNetworkSplit(removedPoleConnections, existingNet);
        }

        private static Map<BlockPos, Set<BlockPos>> FloodFillNetwork(PoleNetwork existing, BlockPos startAt) {
            int maxIterations = 200;
            HashMap<BlockPos, Set<BlockPos>> result = new HashMap<BlockPos, Set<BlockPos>>();
            Set<BlockPos> openChecks = Set.of(startAt);
            for (int i = 0; i < maxIterations; ++i) {
                HashSet<BlockPos> next = new HashSet<BlockPos>();
                for (BlockPos openPole : openChecks) {
                    Set<BlockPos> connections = existing.getConnections(openPole);
                    if (connections == null) continue;
                    result.put(openPole, connections);
                    next.addAll(connections.stream().filter(elem -> !result.containsKey(elem)).toList());
                }
                if (next.isEmpty()) break;
                openChecks = next;
            }
            return result;
        }
    }

    protected class PowerPoleEnergyStorage
    extends EnergyApi.EnergyStorage
    implements UpdatableField<PowerPoleEnergyStorage, Long> {
        private long clientShownEnergy;

        protected PowerPoleEnergyStorage() {
        }

        private boolean isValid() {
            return PowerPoleEntity.this.level != null && PowerPoleEntity.this.isConnected();
        }

        @Override
        public long insert(long maxAmount, boolean simulate) {
            if (!this.isValid()) {
                return 0L;
            }
            long insertAmount = Math.min(maxAmount, this.getCapacity() - this.getAmount());
            if (insertAmount > 0L && !simulate) {
                long newAmount = this.getAmount() + insertAmount;
                this.setAmount(newAmount);
                PowerPoleEntity.this.getNetwork().inserted.add(insertAmount);
            }
            return insertAmount;
        }

        @Override
        public long extract(long maxAmount, boolean simulate) {
            if (!this.isValid()) {
                return 0L;
            }
            long extractAmount = Math.min(maxAmount, this.getAmount());
            if (extractAmount > 0L && !simulate) {
                long newAmount = this.getAmount() - extractAmount;
                this.setAmount(newAmount);
                PowerPoleEntity.this.getNetwork().extracted.add(extractAmount);
            }
            return extractAmount;
        }

        @Override
        public void setAmount(long amount) {
            if (!this.isValid()) {
                return;
            }
            if (amount > this.getCapacity() || amount < 0L) {
                Oritech.LOGGER.error("tried setting invalid amount for pole network: " + amount);
                return;
            }
            PoleNetwork network = PowerPoleEntity.this.getNetwork();
            if (network == null) {
                Oritech.LOGGER.error("Invalid set network state for power pole entity at: {}", (Object)PowerPoleEntity.this.worldPosition);
                return;
            }
            network.storedEnergy = amount;
        }

        @Override
        public long getAmount() {
            if (PowerPoleEntity.this.level.isClientSide()) {
                return this.clientShownEnergy;
            }
            if (!this.isValid()) {
                return 0L;
            }
            PoleNetwork network = PowerPoleEntity.this.getNetwork();
            if (network == null) {
                Oritech.LOGGER.error("Invalid get network state for power pole entity at: {}", (Object)PowerPoleEntity.this.worldPosition);
                return 0L;
            }
            return network.storedEnergy;
        }

        @Override
        public long getCapacity() {
            return Oritech.CONFIG.poleConfig.energyCapacity();
        }

        @Override
        public void update() {
            if (!this.isValid()) {
                return;
            }
            PowerPoleEntity.this.setChanged(false);
        }

        public void tick(long worldTicks) {
            PoleNetwork net = PowerPoleEntity.this.getNetwork();
            if (worldTicks <= net.lastTickedAt) {
                return;
            }
            int index = (int)(worldTicks % 20L);
            net.historicInsert[index] = net.inserted.stream().mapToLong(Long::longValue).sum();
            net.historicExtract[index] = net.extracted.stream().mapToLong(Long::longValue).sum();
            net.currentInsertSources = net.inserted.size();
            net.inserted.clear();
            net.extracted.clear();
            net.lastTickedAt = worldTicks;
        }

        public DynamicStatisticEnergyStorage.EnergyStatistics getCurrentStatistics(long worldTicks) {
            int index = (int)(worldTicks % 20L);
            PoleNetwork net = PowerPoleEntity.this.getNetwork();
            return new DynamicStatisticEnergyStorage.EnergyStatistics((float)Arrays.stream(net.historicInsert).mapToLong(Long::longValue).average().orElse(0.0), (float)Arrays.stream(net.historicExtract).mapToLong(Long::longValue).average().orElse(0.0), net.historicInsert[index], net.historicExtract[index], net.currentInsertSources, Arrays.stream(net.historicInsert).mapToLong(Long::longValue).max().orElse(0L), Arrays.stream(net.historicExtract).mapToLong(Long::longValue).max().orElse(0L));
        }

        @Override
        public Long getDeltaData() {
            return this.getAmount();
        }

        @Override
        public PowerPoleEnergyStorage getFullData() {
            return this;
        }

        @Override
        public StreamCodec<? extends ByteBuf, Long> getDeltaCodec() {
            return ByteBufCodecs.VAR_LONG;
        }

        @Override
        public StreamCodec<? extends ByteBuf, PowerPoleEnergyStorage> getFullCodec() {
            return null;
        }

        @Override
        public boolean useDeltaOnly(SyncType type) {
            return true;
        }

        @Override
        public void handleFullUpdate(PowerPoleEnergyStorage updatedData) {
        }

        @Override
        public void handleDeltaUpdate(Long updatedData) {
            this.clientShownEnergy = updatedData;
        }
    }

    public static class PoleNetwork {
        private final Map<BlockPos, Set<BlockPos>> poles;
        public long storedEnergy = 0L;
        private final List<Long> inserted = new ArrayList<Long>();
        private final List<Long> extracted = new ArrayList<Long>();
        private final Long[] historicInsert = new Long[20];
        private final Long[] historicExtract = new Long[20];
        private int currentInsertSources = 0;
        private long lastTickedAt = 0L;

        private PoleNetwork(Map<BlockPos, Set<BlockPos>> loadedPoles, long storedEnergy) {
            this.poles = new HashMap<BlockPos, Set<BlockPos>>(loadedPoles);
            this.storedEnergy = storedEnergy;
            Arrays.fill((Object[])this.historicInsert, (Object)0L);
            Arrays.fill((Object[])this.historicExtract, (Object)0L);
        }

        public PoleNetwork() {
            this.poles = new HashMap<BlockPos, Set<BlockPos>>();
            Arrays.fill((Object[])this.historicInsert, (Object)0L);
            Arrays.fill((Object[])this.historicExtract, (Object)0L);
        }

        public Set<BlockPos> getPoles() {
            return this.poles.keySet();
        }

        public Set<BlockPos> getConnections(BlockPos polePos) {
            return this.poles.get(polePos);
        }

        public void setPole(BlockPos pole, Set<ConnectionTarget> connections) {
            this.poles.put(pole, new HashSet<BlockPos>(connections.stream().map(elem -> elem.pos()).toList()));
        }
    }

    public record ConnectionTarget(BlockPos pos, Direction facing) {
    }
}

