/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.AdditionalNetworkingProvider;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.FakeMachinePlayer;
import rearth.oritech.util.ScreenProvider;

public class PlacerBlockEntity
extends ItemEnergyFrameInteractionBlockEntity
implements AdditionalNetworkingProvider {
    private ServerPlayer placerPlayerEntity = null;

    public PlacerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PLACER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected boolean hasWorkAvailable(BlockPos toolPosition) {
        ItemStack firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return false;
        }
        Block block = Block.byItem((Item)firstBlock.getItem());
        if (block == null) {
            return false;
        }
        BlockPos targetPosition = toolPosition.below();
        return Objects.requireNonNull(this.level).getBlockState(targetPosition).getBlock().equals(Blocks.AIR) && block.defaultBlockState().canSurvive((LevelReader)this.level, targetPosition);
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
        ItemStack firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return;
        }
        Block block = Block.byItem((Item)firstBlock.getItem());
        if (block == null) {
            return;
        }
        BlockPos targetPosition = processed.below();
        Direction direction = Direction.DOWN;
        BlockHitResult hitResult = new BlockHitResult(new Vec3((double)targetPosition.getX() + 0.5 + (double)direction.getStepX() * 0.5, (double)targetPosition.getY() + 0.5 + (double)direction.getStepY() * 0.5, (double)targetPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.5), direction, targetPosition, false);
        BlockState placementState = block.getStateForPlacement(new BlockPlaceContext(this.getPlacerPlayerEntity(), InteractionHand.MAIN_HAND, firstBlock, hitResult));
        if (Objects.requireNonNull(this.level).getBlockState(targetPosition).isAir() && placementState != null && placementState.canSurvive((LevelReader)this.level, targetPosition)) {
            this.level.setBlockAndUpdate(targetPosition, placementState);
            firstBlock.shrink(1);
            this.level.playSound(null, targetPosition, placementState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            super.finishBlockWork(processed);
        }
    }

    private ItemStack getFirstInInventory() {
        for (ItemStack stack : this.inventory.heldStacks) {
            if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public float getCoreQuality() {
        return 3.0f;
    }

    @Override
    public BlockState getMachineHead() {
        return BlockContent.BLOCK_PLACER_HEAD.defaultBlockState();
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, -1, 0));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38));
    }

    @Override
    public ItemStack getToolheadAdditionalRender() {
        return this.getFirstInInventory();
    }

    @Override
    public float getMoveTime() {
        return (float)Oritech.CONFIG.placerConfig.moveDuration() * this.getSpeedMultiplier();
    }

    @Override
    public float getWorkTime() {
        return (float)Oritech.CONFIG.placerConfig.workDuration() * this.getSpeedMultiplier();
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.placerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.placerConfig.workEnergyUsage();
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.PLACER_SCREEN;
    }

    @Override
    public List<Field> additionalSyncedFields(SyncType type) {
        if (type.equals((Object)SyncType.TICK)) {
            try {
                return List.of(ItemEnergyFrameInteractionBlockEntity.class.getDeclaredField("inventory"));
            }
            catch (NoSuchFieldException e) {
                Oritech.LOGGER.error("unable to register inventory as extra synced field for placed block.");
            }
        }
        return List.of();
    }

    private Player getPlacerPlayerEntity() {
        Level level;
        if (this.placerPlayerEntity == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.placerPlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_placer"), this.inventory);
        }
        return this.placerPlayerEntity;
    }
}

