/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.WorldPacketCodec;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.behavior.LaserArmBlockBehavior;
import rearth.oritech.block.behavior.LaserArmEntityBehavior;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.FakeMachinePlayer;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserArmBlockEntity
extends NetworkedBlockEntity
implements GeoBlockEntity,
EnergyApi.BlockProvider,
ScreenProvider,
ExtendedMenuProvider,
MultiblockMachineController,
MachineAddonController,
ItemApi.BlockProvider,
RedstoneAddonBlockEntity.RedstoneControllable,
ColorableMachine {
    private static final String LASER_PLAYER_NAME = "oritech_laser";
    public static final int BLOCK_BREAK_ENERGY = Oritech.CONFIG.laserArmConfig.blockBreakEnergyBase();
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::setChanged);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(3, this::setChanged);
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<LaserArmBlockEntity> animationController = this.getAnimationController();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN})
    public int areaSize = 1;
    @SyncField(value={SyncType.GUI_OPEN})
    public int yieldAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN})
    public int hunterAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasCropFilterAddon = false;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasSilkTouchAddon = false;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = ColorableMachine.ColorVariant.ORANGE;
    private final int range;
    public Vec3 laserHead;
    private BlockPos targetDirection;
    @SyncField
    private BlockPos currentTarget;
    @SyncField
    public HunterTargetMode hunterTargetMode;
    @SyncField
    private LivingEntity currentLivingTarget;
    @SyncField
    private long lastFiredAt;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    private boolean redstonePowered;
    private int progress;
    private ArrayDeque<BlockPos> pendingArea;
    private final ArrayDeque<LivingEntity> pendingLivingTargets;
    private int targetBlockEnergyNeeded;
    public Vec3 lastRenderPosition;
    private Player laserPlayerEntity;
    public static WorldPacketCodec<RegistryFriendlyByteBuf, LivingEntity> LASER_TARGET_PACKET_CODEC = new WorldPacketCodec<RegistryFriendlyByteBuf, LivingEntity>(){

        @Override
        public LivingEntity decode(RegistryFriendlyByteBuf buf, @Nullable Level world) {
            Entity candidate;
            int id = buf.readInt();
            if (world != null && id >= 0 && (candidate = world.getEntity(id)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)candidate;
                return livingEntity;
            }
            return null;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf buf, LivingEntity value, @Nullable Level world) {
            int id = value != null ? value.getId() : -1;
            buf.writeInt(id);
        }
    };

    public LaserArmBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.LASER_ARM_ENTITY, pos, state);
        this.range = Oritech.CONFIG.laserArmConfig.range();
        this.currentTarget = BlockPos.ZERO;
        this.hunterTargetMode = HunterTargetMode.HOSTILE_ONLY;
        this.pendingLivingTargets = new ArrayDeque();
        this.targetBlockEnergyNeeded = BLOCK_BREAK_ENERGY;
        this.laserPlayerEntity = null;
        this.laserHead = this.getLaserHeadPosition().getCenter();
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state)) {
            return;
        }
        if (!this.redstonePowered && this.energyStorage.getAmount() >= (long)this.energyRequiredToFire()) {
            if (this.hunterAddons > 0) {
                this.fireAtLivingEntities(world, pos, state, this);
            } else if (this.currentTarget != null && !this.currentTarget.equals((Object)BlockPos.ZERO)) {
                this.fireAtBlocks(world, pos, state, this);
            } else if (this.targetDirection != null && !this.targetDirection.equals((Object)BlockPos.ZERO) && (world.getGameTime() + (long)pos.getZ()) % 40L == 0L) {
                this.findNextBlockBreakTarget();
            }
        }
    }

    private void fireAtBlocks(Level world, BlockPos pos, BlockState state, LaserArmBlockEntity blockEntity) {
        BlockPos targetBlockPos = this.currentTarget;
        BlockState targetBlockState = world.getBlockState(targetBlockPos);
        Block targetBlock = targetBlockState.getBlock();
        BlockEntity targetBlockEntity = world.getBlockEntity(targetBlockPos);
        LaserArmBlockBehavior behavior = LaserArmBlock.getBehaviorForBlock(targetBlock);
        boolean fired = false;
        if (behavior.fireAtBlock(world, this, targetBlock, targetBlockPos, targetBlockState, targetBlockEntity)) {
            this.energyStorage.amount -= (long)this.energyRequiredToFire();
            this.lastFiredAt = world.getGameTime();
        } else {
            this.findNextBlockBreakTarget();
        }
    }

    private void fireAtLivingEntities(Level world, BlockPos pos, BlockState state, LaserArmBlockEntity blockEntity) {
        if (this.currentLivingTarget != null && this.validTarget(this.currentLivingTarget)) {
            LaserArmEntityBehavior behavior = LaserArmBlock.getBehaviorForEntity(this.currentLivingTarget.getType());
            if (behavior.fireAtEntity(world, this, this.currentLivingTarget)) {
                this.energyStorage.amount -= (long)this.energyRequiredToFire();
                this.targetDirection = this.currentLivingTarget.blockPosition();
                this.lastFiredAt = world.getGameTime();
            } else {
                this.pendingLivingTargets.remove(this.currentLivingTarget);
                this.currentLivingTarget = null;
                this.currentTarget = BlockPos.ZERO;
            }
        } else {
            this.loadNextLivingTarget();
        }
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    public void addBlockBreakProgress(int progress) {
        this.progress += progress;
    }

    public int getBlockBreakProgress() {
        return this.progress;
    }

    public int getTargetBlockEnergyNeeded() {
        return this.targetBlockEnergyNeeded;
    }

    public void finishBlockBreaking(BlockPos targetPos, BlockState targetBlockState) {
        this.progress -= this.targetBlockEnergyNeeded;
        BlockEntity targetEntity = this.level.getBlockEntity(targetPos);
        List<ItemStack> dropped = this.hasSilkTouchAddon ? DestroyerBlockEntity.getSilkTouchDrops(targetBlockState, (ServerLevel)this.level, targetPos, targetEntity, this.getLaserPlayerEntity()) : (this.yieldAddons > 0 ? DestroyerBlockEntity.getLootDrops(targetBlockState, (ServerLevel)this.level, targetPos, targetEntity, this.yieldAddons, this.getLaserPlayerEntity()) : Block.getDrops((BlockState)targetBlockState, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (BlockEntity)targetEntity, (Entity)this.getLaserPlayerEntity(), (ItemStack)ItemStack.EMPTY));
        RecipeHolder<OritechRecipe> blockRecipe = LaserArmBlockEntity.tryGetRecipeOfBlock(targetBlockState, this.level);
        if (blockRecipe != null) {
            OritechRecipe recipe = (OritechRecipe)blockRecipe.value();
            int farmedCount = 1 + this.yieldAddons;
            dropped = List.of(new ItemStack((ItemLike)recipe.getResults().get(0).getItem(), farmedCount));
            ParticleContent.CHARGING.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)targetPos), (Object)1);
        }
        for (ItemStack stack : dropped) {
            this.inventory.insert(stack, false);
        }
        try {
            targetBlockState.getBlock().playerWillDestroy(this.level, targetPos, targetBlockState, this.getLaserPlayerEntity());
        }
        catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + String.valueOf(targetBlockState) + " at " + String.valueOf(targetPos) + ": " + exception.getLocalizedMessage());
        }
        this.level.addDestroyBlockEffect(targetPos, this.level.getBlockState(targetPos));
        this.level.playSound(null, targetPos, targetBlockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.destroyBlock(targetPos, false);
        this.findNextBlockBreakTarget();
    }

    public static RecipeHolder<OritechRecipe> tryGetRecipeOfBlock(BlockState destroyed, Level world) {
        Item inputItem = destroyed.getBlock().asItem();
        SimpleCraftingInventory inputInv = new SimpleCraftingInventory(new ItemStack((ItemLike)inputItem));
        Optional candidate = world.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.LASER, (RecipeInput)inputInv, world);
        return candidate.orElse(null);
    }

    public Player getLaserPlayerEntity() {
        if (!(this.level instanceof ServerLevel)) {
            return null;
        }
        if (this.laserPlayerEntity == null) {
            this.laserPlayerEntity = FakeMachinePlayer.create((ServerLevel)this.level, new GameProfile(UUID.randomUUID(), LASER_PLAYER_NAME), this.inventory);
        }
        if (this.hunterAddons > 0 && this.yieldAddons > 0) {
            ItemStack lootingSword = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
            lootingSword.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            Holder.Reference lootingEntry = (Holder.Reference)this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.LOOTING).get();
            lootingSword.enchant((Holder)lootingEntry, Math.min(this.yieldAddons, 3));
            this.laserPlayerEntity.getInventory().items.set(this.laserPlayerEntity.getInventory().selected, (Object)lootingSword);
        }
        return this.laserPlayerEntity;
    }

    private void findNextBlockBreakTarget() {
        while (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            if (!this.trySetNewTarget(this.pendingArea.pop(), false)) continue;
            if (this.pendingArea.isEmpty()) {
                this.pendingArea = null;
            }
            return;
        }
        Vec3 direction = Vec3.atLowerCornerOf((Vec3i)this.targetDirection.subtract((Vec3i)this.getLaserHeadPosition())).normalize();
        Vec3 from = this.laserHead.add(direction.scale(1.5));
        BlockPos nextBlock = this.basicRaycast(from, direction, this.range, 0.45f);
        if (nextBlock == null) {
            this.currentTarget = BlockPos.ZERO;
            return;
        }
        int maxSize = (int)from.distanceTo(nextBlock.getCenter()) - 1;
        int scanDist = Math.min(this.areaSize, maxSize);
        if (scanDist > 1) {
            this.pendingArea = this.findNextAreaBlockTarget(nextBlock, scanDist);
        }
        if (!this.trySetNewTarget(nextBlock, false)) {
            this.currentTarget = BlockPos.ZERO;
        }
    }

    private double hunterRange() {
        return Math.pow(4.0, Math.min(this.hunterAddons, 3)) + 0.5;
    }

    private boolean canSee(LivingEntity entity) {
        if (entity.level() != this.getLevel() || entity.isInvisible()) {
            return false;
        }
        Vec3 target = entity.getEyePosition();
        Vec3 direction = target.subtract(this.laserHead).normalize();
        if (this.laserHead.distanceTo(target) > 128.0) {
            return false;
        }
        return this.basicRaycast(this.laserHead.add(direction.scale(1.5)), direction, (int)(this.laserHead.distanceTo(target) - 1.0), 0.2f) == null;
    }

    private boolean validTarget(LivingEntity entity) {
        return entity.isAlive() && this.canSee(entity) && this.huntedTarget(entity) && entity.position().closerThan((Position)this.getLaserHeadPosition().getCenter(), this.hunterRange());
    }

    private boolean huntedTarget(LivingEntity entity) {
        if (entity instanceof Player) {
            return true;
        }
        return switch (this.hunterTargetMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> entity instanceof Enemy;
            case 1 -> {
                Animal animal;
                if (entity instanceof Animal && (animal = (Animal)entity).getLoveCause() == null || entity instanceof WaterAnimal) {
                    yield true;
                }
                yield entity instanceof Enemy;
            }
            case 2 -> true;
        };
    }

    private void loadNextLivingTarget() {
        if (this.pendingLivingTargets.isEmpty() && (this.level.getGameTime() + this.worldPosition.asLong()) % 10L == 0L) {
            this.updateEntityTargets();
        }
        while (!this.pendingLivingTargets.isEmpty()) {
            LivingEntity candidate = this.pendingLivingTargets.pop();
            if (!this.validTarget(candidate)) continue;
            this.currentLivingTarget = candidate;
            this.currentTarget = candidate.blockPosition();
            return;
        }
    }

    private void updateEntityTargets() {
        double entityRange = this.hunterRange();
        List targets = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.laserHead.x - entityRange, this.laserHead.y - entityRange, this.laserHead.z - entityRange, this.laserHead.x + entityRange, this.laserHead.y + entityRange, this.laserHead.z + entityRange), EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
        targets.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr(this.laserHead)));
        this.pendingLivingTargets.addAll(targets);
    }

    private ArrayDeque<BlockPos> findNextAreaBlockTarget(BlockPos center, int scanDist) {
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        for (int x = -scanDist; x < scanDist; ++x) {
            for (int y = -scanDist; y < scanDist; ++y) {
                for (int z = -scanDist; z < scanDist; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    if (this.canPassThrough(this.level.getBlockState(pos), pos) || center.equals((Object)pos)) continue;
                    targets.add(pos);
                }
            }
        }
        targets.sort(Comparator.comparingInt(arg_0 -> ((BlockPos)this.worldPosition).distManhattan(arg_0)));
        return new ArrayDeque<BlockPos>(targets);
    }

    private BlockPos basicRaycast(Vec3 from, Vec3 direction, int range, float searchOffset) {
        for (float i = 0.0f; i < (float)range; i += 0.3f) {
            Vec3 to = from.add(direction.scale((double)i));
            BlockPos targetBlockPos = BlockPos.containing((Position)to.add(0.0, (double)searchOffset, 0.0));
            BlockState targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            if (searchOffset == 0.0f) {
                return null;
            }
            Vec3 offsetTop = to.add(0.0, (double)(-searchOffset), 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetTop);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetLeft = to.add((double)(-searchOffset), 0.0, 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetLeft);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetRight = to.add((double)searchOffset, 0.0, 0.0);
            targetBlockPos = BlockPos.containing((Position)offsetRight);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetFront = to.add(0.0, 0.0, (double)searchOffset);
            targetBlockPos = BlockPos.containing((Position)offsetFront);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            Vec3 offsetBack = to.add(0.0, 0.0, (double)(-searchOffset));
            targetBlockPos = BlockPos.containing((Position)offsetBack);
            targetState = this.level.getBlockState(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (this.canPassThrough(targetState, targetBlockPos)) continue;
            return targetBlockPos;
        }
        return null;
    }

    private boolean isSearchTerminatorBlock(BlockState state) {
        return state.getBlock().equals(Blocks.TARGET);
    }

    public boolean canPassThrough(BlockState state, BlockPos blockPos) {
        return state.isAir() || !state.getFluidState().isEmpty() || state.is(TagContent.LASER_PASSTHROUGH) || this.hunterAddons > 0 && !state.isRedstoneConductor((BlockGetter)this.level, blockPos);
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.areaSize = 1;
        this.yieldAddons = 0;
        this.hunterAddons = 0;
        this.hasCropFilterAddon = false;
        this.hasSilkTouchAddon = false;
        MachineAddonController.super.gatherAddonStats(addons);
        this.yieldAddons = Math.min(this.yieldAddons, 3);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        AddonBlockEntity addonBlockEntity;
        MachineAddonController.super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().getBlock().equals(BlockContent.QUARRY_ADDON)) {
            ++this.areaSize;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_HUNTER_ADDON)) {
            ++this.hunterAddons;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            ++this.yieldAddons;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.CROP_FILTER_ADDON)) {
            this.hasCropFilterAddon = true;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) {
            this.hasSilkTouchAddon = true;
        }
        if ((addonBlockEntity = addonBlock.addonEntity()) instanceof CombiAddonEntity) {
            CombiAddonEntity combi = (CombiAddonEntity)addonBlockEntity;
            this.areaSize = combi.getQuarryCount();
            this.yieldAddons = combi.getYieldCount();
            this.hasCropFilterAddon = combi.hasCropFilter();
            this.hasSilkTouchAddon = combi.hasSilk();
        }
    }

    public int energyRequiredToFire() {
        return (int)((float)Oritech.CONFIG.laserArmConfig.energyPerTick() * (1.0f / this.addonData.speed()));
    }

    public float getDamageTick() {
        return Oritech.CONFIG.laserArmConfig.damageTickBase() * (1.0f / this.addonData.speed());
    }

    public boolean setTargetFromDesignator(BlockPos targetPos) {
        boolean success = this.trySetNewTarget(targetPos, true);
        this.findNextBlockBreakTarget();
        return success;
    }

    public void cycleHunterTargetMode() {
        this.hunterTargetMode = this.hunterTargetMode.next();
    }

    private boolean trySetNewTarget(BlockPos targetPos, boolean alsoSetDirection) {
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPos);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.level.getBlockEntity(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        int distance = targetPos.distManhattan((Vec3i)this.worldPosition);
        float blockHardness = targetState.getBlock().defaultDestroyTime();
        if (distance > this.range || (double)blockHardness < 0.0 || targetState.getBlock().equals(Blocks.AIR)) {
            return false;
        }
        this.targetBlockEnergyNeeded = (int)((double)BLOCK_BREAK_ENERGY * Math.pow(blockHardness, Oritech.CONFIG.blockBreakHardnessExponentialFactor()) * (double)this.addonData.efficiency());
        if (targetState.is(TagContent.LASER_FAST_BREAKING)) {
            this.targetBlockEnergyNeeded /= 8;
        }
        this.currentTarget = targetPos;
        if (alsoSetDirection) {
            this.targetDirection = targetPos;
            this.pendingArea = null;
            this.setChanged();
        }
        this.setChanged();
        return true;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.addColorToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putBoolean("redstone", this.redstonePowered);
        nbt.putInt("areaSize", this.areaSize);
        nbt.putInt("yieldAddons", this.yieldAddons);
        nbt.putInt("hunterAddons", this.hunterAddons);
        nbt.putBoolean("cropAddon", this.hasCropFilterAddon);
        nbt.putBoolean("silkAddon", this.hasSilkTouchAddon);
        nbt.putInt("hunterTargetMode", this.hunterTargetMode.value);
        if (this.targetDirection != null && this.currentTarget != null) {
            nbt.putLong("target_position", this.currentTarget.asLong());
            nbt.putLong("target_direction", this.targetDirection.asLong());
        }
        if (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            long[] positions = this.pendingArea.stream().mapToLong(BlockPos::asLong).toArray();
            nbt.putLongArray("pendingPositions", positions);
        } else {
            nbt.remove("pendingPositions");
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.loadColorFromNbt(nbt);
        this.updateEnergyContainer();
        this.redstonePowered = nbt.getBoolean("redstone");
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.targetDirection = BlockPos.of((long)nbt.getLong("target_direction"));
        this.currentTarget = BlockPos.of((long)nbt.getLong("target_position"));
        this.areaSize = nbt.getInt("areaSize");
        this.yieldAddons = nbt.getInt("yieldAddons");
        this.hunterAddons = nbt.getInt("hunterAddons");
        this.hunterTargetMode = HunterTargetMode.fromValue(nbt.getInt("hunterTargetMode"));
        this.hasCropFilterAddon = nbt.getBoolean("cropAddon");
        this.hasSilkTouchAddon = nbt.getBoolean("silkAddon");
        if (nbt.contains("pendingPositions")) {
            this.pendingArea = Arrays.stream(nbt.getLongArray("pendingPositions")).mapToObj(BlockPos::of).collect(Collectors.toCollection(ArrayDeque::new));
        }
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public Direction getFacingForMultiblock() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite();
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(1, 0, 0));
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return null;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(-1, 0, 0));
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.laserArmConfig.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.laserArmConfig.maxEnergyInsertion();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<LaserArmBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                if (this.isFiring()) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).triggerableAnim("setup", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler());
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("base_controller", "setup");
    }

    @Override
    public void sendUpdate(SyncType type, ServerPlayer player) {
        if (type.equals((Object)SyncType.GUI_TICK)) {
            super.sendUpdate(SyncType.GUI_OPEN, player);
            return;
        }
        super.sendUpdate(type, player);
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public BlockPos getCurrentTarget() {
        return this.currentTarget;
    }

    public Vec3 getVisualTarget() {
        if (this.hunterAddons > 0 && this.currentLivingTarget != null) {
            return this.currentLivingTarget.getEyePosition().subtract(0.5, 0.0, 0.5);
        }
        return this.getCurrentTarget().getCenter();
    }

    @Override
    public BlockPos getPosForAddon() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForAddon() {
        return this.getLevel();
    }

    public boolean isFiring() {
        long idleTime = this.level.getGameTime() - this.lastFiredAt;
        return idleTime < 5L;
    }

    @Override
    public int getTickUpdateInterval() {
        return 2;
    }

    public boolean isTargetingAtomicForge(Block block) {
        return block.equals(BlockContent.ATOMIC_FORGE_BLOCK);
    }

    public boolean isTargetingDeepdrill(Block block) {
        return block.equals(BlockContent.DEEP_DRILL_BLOCK);
    }

    public boolean isTargetingCatalyst(Block block) {
        return block.equals(BlockContent.ENCHANTMENT_CATALYST_BLOCK);
    }

    public boolean isTargetingUnstableContainer(Block block) {
        return block.equals(BlockContent.UNSTABLE_CONTAINER);
    }

    public boolean isTargetingEnergyContainer() {
        EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(this.level, this.currentTarget, null);
        Block block = this.level.getBlockState(this.currentTarget).getBlock();
        return storageCandidate != null || this.isTargetingAtomicForge(block) || this.isTargetingDeepdrill(block) || this.isTargetingCatalyst(block) || this.isTargetingUnstableContainer(block);
    }

    public boolean isTargetingBuddingAmethyst() {
        return this.level.getBlockState(this.currentTarget).is(TagContent.LASER_ACCELERATED);
    }

    @Override
    public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        if (this.areaSize == 1 && this.yieldAddons == 0 && this.hunterAddons == 0 && !this.hasSilkTouchAddon) {
            return ScreenProvider.super.getExtraExtensionLabels();
        }
        if (this.hunterAddons > 0) {
            return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{(int)this.hunterRange()}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_hunter_range")), new Tuple((Object)Component.translatable((String)"title.oritech.laser_arm.addon_hunter_damage", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getDamageTick()))}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_hunter_damage")), new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_looting", (Object[])new Object[]{this.yieldAddons}), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_looting")));
        }
        if (this.hasSilkTouchAddon) {
            return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.areaSize}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_range")), new Tuple((Object)Component.translatable((String)"enchantment.minecraft.silk_touch"), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_silk_touch")));
        }
        return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.areaSize}), (Object)Component.translatable((String)"tooltip.oritech.laser_arm.addon_range")), new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_fortune", (Object[])new Object[]{this.yieldAddons}), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 20, true), new ScreenProvider.GuiSlot(1, 117, 38, true), new ScreenProvider.GuiSlot(2, 117, 56, true));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.energyRequiredToFire();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.LASER_SCREEN;
    }

    @Override
    public Property<Direction> getBlockFacingProperty() {
        return BlockStateProperties.FACING;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentTarget == null || this.currentTarget.equals((Object)BlockPos.ZERO)) {
            return 0;
        }
        return (int)(this.currentTarget.distSqr((Vec3i)this.worldPosition) / (double)this.range) * 15;
    }

    @Override
    public int getComparatorActiveState() {
        long idleTicks = this.level.getGameTime() - this.lastFiredAt;
        return idleTicks > 3L ? 15 : 0;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.level.getBestNeighborSignal(this.worldPosition);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.redstonePowered) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }

    public BlockPos getLaserHeadPosition() {
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        Vec3i offset = new Vec3i(-1, 0, 0);
        return new BlockPos(Geometry.offsetToWorldPosition(facing, offset, (Vec3i)this.worldPosition));
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    public static enum HunterTargetMode {
        HOSTILE_ONLY(1, "message.oritech.target_designator.hunter_hostile"),
        HOSTILE_NEUTRAL(2, "message.oritech.target_designator.hunter_neutral"),
        ALL(3, "message.oritech.target_designator.hunter_all");

        public final int value;
        public final String message;
        private static final Map<Integer, HunterTargetMode> map;

        private HunterTargetMode(int value, String message) {
            this.value = value;
            this.message = message;
        }

        public static HunterTargetMode fromValue(int i) {
            return map.getOrDefault(i, HOSTILE_ONLY);
        }

        public HunterTargetMode next() {
            return HunterTargetMode.values()[(this.ordinal() + 1) % HunterTargetMode.values().length];
        }

        static {
            map = new HashMap<Integer, HunterTargetMode>();
            for (HunterTargetMode targetMode : HunterTargetMode.values()) {
                map.put(targetMode.value, targetMode);
            }
        }
    }
}

