/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.behavior;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.TagContent;

public class LaserArmBlockBehavior {
    private static LaserArmBlockBehavior noop;
    private static LaserArmBlockBehavior transferPowerBehavior;
    private static LaserArmBlockBehavior energizeBuddingBehavior;

    public boolean fireAtBlock(Level world, LaserArmBlockEntity laserEntity, Block block, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (laserEntity.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(blockState)) {
            return false;
        }
        EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
        if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
            EnergyApi.BlockProvider provider = (EnergyApi.BlockProvider)blockEntity;
            storageCandidate = provider.getEnergyStorage(null);
        }
        if (storageCandidate != null) {
            return transferPowerBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        }
        if (blockState.is(TagContent.LASER_ACCELERATED)) {
            return energizeBuddingBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        }
        if (blockState.is(TagContent.LASER_PASSTHROUGH)) {
            return false;
        }
        laserEntity.addBlockBreakProgress(laserEntity.energyRequiredToFire());
        if (laserEntity.getBlockBreakProgress() >= laserEntity.getTargetBlockEnergyNeeded()) {
            laserEntity.finishBlockBreaking(blockPos, blockState);
        }
        return true;
    }

    public static void registerDefaults() {
        noop = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(Level world, LaserArmBlockEntity laserEntity, Block block, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
                return false;
            }
        };
        LaserArmBlock.registerBlockBehavior(Blocks.TARGET, noop);
        LaserArmBlock.registerBlockBehavior(Blocks.BEDROCK, noop);
        transferPowerBehavior = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(Level world, LaserArmBlockEntity laserEntity, Block block, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
                long insertAmount;
                EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
                if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
                    EnergyApi.BlockProvider energyProvider = (EnergyApi.BlockProvider)blockEntity;
                    storageCandidate = energyProvider.getEnergyStorage(null);
                }
                if (blockEntity instanceof UnstableContainerBlockEntity) {
                    UnstableContainerBlockEntity unstableContainerBlockEntity = (UnstableContainerBlockEntity)blockEntity;
                    storageCandidate = unstableContainerBlockEntity.laserInputStorage;
                }
                if ((insertAmount = storageCandidate.getCapacity() - storageCandidate.getAmount()) <= 0L || storageCandidate.getCapacity() <= 1L) {
                    return false;
                }
                long transferCapacity = Math.min(insertAmount, (long)laserEntity.energyRequiredToFire());
                if (storageCandidate instanceof DynamicEnergyStorage) {
                    DynamicEnergyStorage dynamicStorage = (DynamicEnergyStorage)storageCandidate;
                    long inserted = dynamicStorage.insertIgnoringLimit(transferCapacity, true);
                    if (inserted > 0L && inserted <= transferCapacity) {
                        dynamicStorage.insertIgnoringLimit(transferCapacity, false);
                        dynamicStorage.update();
                        if (blockEntity instanceof AtomicForgeBlockEntity) {
                            AtomicForgeBlockEntity atomicForgeBlock = (AtomicForgeBlockEntity)blockEntity;
                            atomicForgeBlock.lastWorkedAt = world.getGameTime();
                        }
                        return true;
                    }
                    return false;
                }
                long inserted = storageCandidate.insert(transferCapacity, true);
                if (inserted > 0L && inserted <= transferCapacity) {
                    storageCandidate.insert(transferCapacity, false);
                    storageCandidate.update();
                    return true;
                }
                return false;
            }
        };
        LaserArmBlock.registerBlockBehavior(BlockContent.ATOMIC_FORGE_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.DEEP_DRILL_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.ENCHANTMENT_CATALYST_BLOCK, transferPowerBehavior);
        energizeBuddingBehavior = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(Level world, LaserArmBlockEntity laserEntity, Block block, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
                if (world.getGameTime() % 40L == 0L) {
                    return false;
                }
                if (blockState.isAir() || !blockState.getFluidState().isEmpty()) {
                    return false;
                }
                blockState.randomTick((ServerLevel)world, blockPos, world.random);
                ParticleContent.ACCELERATING.spawn(world, Vec3.atLowerCornerOf((Vec3i)blockPos));
                return true;
            }
        };
        LaserArmBlock.registerBlockBehavior(Blocks.BUDDING_AMETHYST, energizeBuddingBehavior);
    }
}

