/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class MachineBlockEntity
extends NetworkedBlockEntity
implements ExtendedMenuProvider,
GeoBlockEntity,
EnergyApi.BlockProvider,
ScreenProvider,
ItemApi.BlockProvider,
RedstoneAddonBlockEntity.RedstoneControllable,
ColorableMachine {
    public static final RawAnimation PACKAGED = RawAnimation.begin().thenPlayAndHold("packaged");
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("deploy");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlayAndHold("idle");
    public static final RawAnimation WORKING = RawAnimation.begin().thenPlay("working");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK})
    public int progress;
    @SyncField(value={SyncType.GUI_TICK})
    protected OritechRecipe currentRecipe = OritechRecipe.DUMMY;
    @SyncField(value={SyncType.GUI_TICK})
    protected InventoryInputMode inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
    @SyncField(value={SyncType.GUI_TICK})
    protected boolean disabledViaRedstone = false;
    @SyncField(value={SyncType.TICK})
    public long lastWorkedAt;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();
    protected int energyPerTick;
    public final FilteringInventory inventory = new FilteringInventory(this.getInventorySize(), this::setChanged, this.getSlotAssignments());
    private final Map<Direction, ItemApi.InventoryStorage> sidedInventories = new HashMap<Direction, ItemApi.InventoryStorage>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::setChanged, this.canEnergyStorageChangeWhileGUIOpen());

    public MachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state);
        this.energyPerTick = energyPerTick;
        if (this.level != null) {
            this.lastWorkedAt = this.level.getGameTime();
        }
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent() && this.canOutputRecipe((OritechRecipe)recipeCandidate.get().value()) && this.canProceed((OritechRecipe)recipeCandidate.get().value())) {
            if (this.currentRecipe != recipeCandidate.get().value()) {
                this.resetProgress();
            }
            if (this.hasEnoughEnergy()) {
                OritechRecipe activeRecipe;
                this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
                this.lastWorkedAt = world.getGameTime();
                this.useEnergy();
                ++this.progress;
                if (this.checkCraftingFinished(activeRecipe)) {
                    this.craftItem(activeRecipe, this.getOutputView(), this.getInputView());
                    this.resetProgress();
                }
                this.setChanged();
            }
        } else if (this.progress > 0) {
            this.resetProgress();
        }
    }

    protected boolean canProceed(OritechRecipe value) {
        return true;
    }

    protected boolean hasEnoughEnergy() {
        return (float)this.energyStorage.amount >= this.calculateEnergyUsage();
    }

    protected void useEnergy() {
        this.energyStorage.amount = (long)((float)this.energyStorage.amount - this.calculateEnergyUsage());
    }

    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * this.getEfficiencyMultiplier() * (1.0f / this.getSpeedMultiplier());
    }

    public List<ItemStack> getCraftingResults(OritechRecipe activeRecipe) {
        return activeRecipe.getResults();
    }

    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        List<ItemStack> results = this.getCraftingResults(activeRecipe);
        List<Ingredient> inputs = activeRecipe.getInputs();
        for (int i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            ItemStack slot = outputInventory.get(i);
            int newCount = slot.getCount() + result.getCount();
            if (slot.isEmpty()) {
                outputInventory.set(i, result.copy());
                continue;
            }
            slot.setCount(newCount);
        }
        int startOffset = 0;
        block1: for (Ingredient removedIng : inputs) {
            for (int i = 0; i < inputInventory.size(); ++i) {
                ItemStack inputStack = inputInventory.get((i + startOffset) % inputInventory.size());
                if (!removedIng.test(inputStack)) continue;
                inputStack.shrink(1);
                ++startOffset;
                continue block1;
            }
        }
    }

    protected boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return (float)this.progress >= (float)activeRecipe.getTime() * this.getSpeedMultiplier();
    }

    protected void resetProgress() {
        this.progress = 0;
    }

    public boolean canOutputRecipe(OritechRecipe recipe) {
        Container outInv = this.getOutputInventory();
        if (outInv.isEmpty()) {
            return true;
        }
        List<ItemStack> results = recipe.getResults();
        for (int i = 0; i < results.size(); ++i) {
            ItemStack result = results.get(i);
            ItemStack outSlot = outInv.getItem(i);
            if (outSlot.isEmpty() || this.canAddToSlot(result, outSlot)) continue;
            return false;
        }
        return true;
    }

    protected boolean canAddToSlot(ItemStack input, ItemStack slot) {
        if (slot.isEmpty()) {
            return true;
        }
        if (!slot.getItem().equals(input.getItem())) {
            return false;
        }
        return slot.getCount() + input.getCount() <= slot.getMaxStackSize();
    }

    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        if (this.currentRecipe != null && this.currentRecipe != OritechRecipe.DUMMY && this.currentRecipe.matches(this.getInputInventory(), this.level)) {
            return Optional.of(new RecipeHolder(this.currentRecipe.getOriType().getIdentifier(), (Recipe)this.currentRecipe));
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
    }

    protected abstract OritechRecipeType getOwnRecipeType();

    public abstract InventorySlotAssignment getSlotAssignments();

    protected List<ItemStack> getInputView() {
        InventorySlotAssignment slots = this.getSlotAssignments();
        return this.inventory.heldStacks.subList(slots.inputStart(), slots.inputStart() + slots.inputCount());
    }

    protected List<ItemStack> getOutputView() {
        InventorySlotAssignment slots = this.getSlotAssignments();
        return this.inventory.heldStacks.subList(slots.outputStart(), slots.outputStart() + slots.outputCount());
    }

    protected RecipeInput getInputInventory() {
        return new SimpleCraftingInventory((ItemStack[])this.getInputView().toArray(ItemStack[]::new));
    }

    protected Container getOutputInventory() {
        return new SimpleContainer((ItemStack[])this.getOutputView().toArray(ItemStack[]::new));
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putInt("oritech.machine_progress", this.progress);
        nbt.putLong("oritech.machine_energy", this.energyStorage.amount);
        nbt.putShort("oritech.machine_input_mode", (short)this.inventoryInputMode.ordinal());
        nbt.putBoolean("oritech.redstone", this.disabledViaRedstone);
        this.addColorToNbt(nbt);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.progress = nbt.getInt("oritech.machine_progress");
        this.energyStorage.amount = nbt.getLong("oritech.machine_energy");
        this.inventoryInputMode = InventoryInputMode.values()[nbt.getShort("oritech.machine_input_mode")];
        this.disabledViaRedstone = nbt.getBoolean("oritech.redstone");
        this.loadColorFromNbt(nbt);
    }

    private int findLowestMatchingSlot(ItemStack stack, List<ItemStack> inv, boolean allowEmpty) {
        int lowestMatchingIndex = -1;
        int lowestMatchingCount = 64;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack invSlot = inv.get(i);
            if (invSlot.isEmpty() && allowEmpty) {
                return i;
            }
            if (!invSlot.getItem().equals(stack.getItem()) || invSlot.getCount() >= lowestMatchingCount) continue;
            lowestMatchingIndex = i;
            lowestMatchingCount = invSlot.getCount();
        }
        return lowestMatchingIndex;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::onAnimationUpdate).triggerableAnim("setup", SETUP).setAnimationSpeedHandler(animatable -> this.getAnimationSpeed()).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler(this::getAnimationSpeed)));
    }

    public PlayState onAnimationUpdate(AnimationState<MachineBlockEntity> state) {
        if (state.getController().isPlayingTriggeredAnimation()) {
            return PlayState.CONTINUE;
        }
        if (this.isActive(this.getBlockState())) {
            if (this.isActivelyWorking()) {
                return state.setAndContinue(WORKING);
            }
            return state.setAndContinue(IDLE);
        }
        return state.setAndContinue(PACKAGED);
    }

    public boolean isActivelyWorking() {
        return this.level.getGameTime() - this.lastWorkedAt < 15L;
    }

    protected float getAnimationSpeed() {
        if (this.getRecipeDuration() < 0) {
            return 1.0f;
        }
        float recipeTicks = (float)this.getRecipeDuration() * this.getSpeedMultiplier();
        return (float)this.getAnimationDuration() / recipeTicks * 0.99f;
    }

    public int getAnimationDuration() {
        return 60;
    }

    protected int getRecipeDuration() {
        return this.getCurrentRecipe().getTime();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    protected Direction getFacing() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public abstract List<ScreenProvider.GuiSlot> getGuiSlots();

    @Override
    public float getProgress() {
        return (float)this.progress / ((float)this.currentRecipe.getTime() * this.getSpeedMultiplier());
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public OritechRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(OritechRecipe currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public float getEfficiencyMultiplier() {
        return 1.0f;
    }

    public void cycleInputMode() {
        switch (this.inventoryInputMode) {
            case FILL_LEFT_TO_RIGHT: {
                this.inventoryInputMode = InventoryInputMode.FILL_EVENLY;
                break;
            }
            case FILL_EVENLY: {
                this.inventoryInputMode = InventoryInputMode.SIDED;
                break;
            }
            case SIDED: {
                this.inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
            }
        }
        this.setChanged();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return this.inventoryInputMode;
    }

    public abstract int getInventorySize();

    public boolean isActive(BlockState state) {
        return true;
    }

    public void setEnergyStored(long amount) {
        this.energyStorage.amount = amount;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    public long getDefaultCapacity() {
        return 5000L;
    }

    public long getDefaultInsertRate() {
        return 1024L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public long getDefaultExtractionRate() {
        return 0L;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        if (this.inventoryInputMode.equals((Object)InventoryInputMode.SIDED)) {
            return this.sidedInventories.computeIfAbsent(direction, this::getDirectedStorage);
        }
        return this.inventory;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentRecipe.getTime() <= 0) {
            return 0;
        }
        return (int)((float)this.progress / (float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * 15.0f);
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    public boolean canEnergyStorageChangeWhileGUIOpen() {
        return false;
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    public static void receiveCycleModePacket(InventoryInputModeSelectorPacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = player.level().getBlockEntity(packet.position());
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)blockEntity;
            machineBlock.cycleInputMode();
        }
    }

    public ItemApi.InventoryStorage getDirectedStorage(Direction direction) {
        InventorySlotAssignment slots = this.getSlotAssignments();
        if (slots.inputCount() <= 1) {
            return this.inventory;
        }
        if (direction == null) {
            return this.inventory;
        }
        if (direction.equals((Object)Direction.UP)) {
            return new DelegatingInventoryStorage(this, this.inventory, () -> true){

                @Override
                public int extract(ItemStack extracted, boolean simulate) {
                    return 0;
                }

                @Override
                public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
                    return 0;
                }

                @Override
                public boolean supportsExtraction() {
                    return false;
                }
            };
        }
        if (direction.equals((Object)Direction.DOWN)) {
            return new DelegatingInventoryStorage(this, this.inventory, () -> true){

                @Override
                public int insert(ItemStack inserted, boolean simulate) {
                    return 0;
                }

                @Override
                public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
                    return 0;
                }

                @Override
                public boolean supportsInsertion() {
                    return false;
                }
            };
        }
        int horizontalOrdinal = 0;
        if (direction.equals((Object)Direction.EAST)) {
            horizontalOrdinal = 1;
        }
        if (direction.equals((Object)Direction.SOUTH)) {
            horizontalOrdinal = 2;
        }
        if (direction.equals((Object)Direction.WEST)) {
            horizontalOrdinal = 3;
        }
        final int inputSlotIndex = slots.inputStart() + horizontalOrdinal % slots.inputCount();
        return new DelegatingInventoryStorage(this, this.inventory, () -> true){

            @Override
            public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
                if (slot != inputSlotIndex) {
                    return 0;
                }
                return super.insertToSlot(inserted, slot, simulate);
            }

            @Override
            public int insert(ItemStack inserted, boolean simulate) {
                return this.insertToSlot(inserted, inputSlotIndex, simulate);
            }
        };
    }

    public class FilteringInventory
    extends InOutInventoryStorage {
        public FilteringInventory(int size, Runnable onUpdate, InventorySlotAssignment slotAssignment) {
            super(size, onUpdate, slotAssignment);
        }

        @Override
        public int insert(ItemStack toInsert, boolean simulate) {
            if (MachineBlockEntity.this.inventoryInputMode.equals((Object)InventoryInputMode.FILL_EVENLY)) {
                int remaining = toInsert.getCount();
                int slotCountTarget = toInsert.getCount() / MachineBlockEntity.this.getSlotAssignments().inputCount();
                slotCountTarget = Math.clamp((long)slotCountTarget, 1, remaining);
                int lowestSlot = 0;
                int lowestSlotCount = Integer.MAX_VALUE;
                for (int i = MachineBlockEntity.this.getSlotAssignments().inputStart(); i < MachineBlockEntity.this.getSlotAssignments().inputStart() + MachineBlockEntity.this.getSlotAssignments().inputCount(); ++i) {
                    ItemStack content = this.getItem(i);
                    if (!content.isEmpty() && !content.getItem().equals(toInsert.getItem()) || content.getCount() >= lowestSlotCount) continue;
                    lowestSlotCount = content.getCount();
                    lowestSlot = i;
                }
                for (int slot = 0; slot < this.getContainerSize() && remaining > 0; remaining -= this.customSlotInsert(toInsert.copyWithCount(slotCountTarget), (slot + lowestSlot) % this.getContainerSize(), simulate), ++slot) {
                }
                return toInsert.getCount() - remaining;
            }
            return super.insert(toInsert, simulate);
        }

        @Override
        public int insertToSlot(ItemStack addedStack, int slot, boolean simulate) {
            if (MachineBlockEntity.this.inventoryInputMode.equals((Object)InventoryInputMode.FILL_EVENLY)) {
                return this.insert(addedStack, simulate);
            }
            return this.customSlotInsert(addedStack, slot, simulate);
        }

        private int customSlotInsert(ItemStack toInsert, int slot, boolean simulate) {
            return super.insertToSlot(toInsert, slot, simulate);
        }
    }

    public record InventoryInputModeSelectorPacket(BlockPos position) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<InventoryInputModeSelectorPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("input_mode"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

