/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;
import rearth.oritech.client.cablesurfer.ZiplineFxHandler;
import rearth.oritech.client.init.ModRenderers;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.AugmentSelectionScreen;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.util.Helpers;

public final class OritechClient {
    public static final KeyMapping AUGMENT_SELECTOR = new KeyMapping("key.oritech.augment_screen", 71, "key.categories.misc");
    public static AugmentSelectionScreen activeScreen = null;
    public static boolean laserActive = false;

    public static void initialize() {
        Oritech.LOGGER.info("Oritech client initialization");
        ModScreens.registerScreens();
        KeyMappingRegistry.register((KeyMapping)AUGMENT_SELECTOR);
        ClientTickEvent.CLIENT_PRE.register(Helpers::onClientTickEvent);
        ClientTickEvent.CLIENT_PRE.register(client -> {
            if (PlayerAugments.allAugments.isEmpty() && client.level != null) {
                PlayerAugments.loadAllAugments(client.level.getRecipeManager());
            }
            if (AUGMENT_SELECTOR.consumeClick() && activeScreen == null) {
                activeScreen = new AugmentSelectionScreen();
                client.setScreen((Screen)activeScreen);
            } else if (activeScreen != null && !InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)OritechClient.AUGMENT_SELECTOR.key.getValue())) {
                activeScreen.onClose();
            }
        });
        ClientTickEvent.CLIENT_PRE.register(client -> {
            LocalPlayer player = client.player;
            if (player == null) {
                return;
            }
            for (Augment augment : PlayerAugments.allAugments.values()) {
                if (!augment.isEnabled((Player)player)) continue;
                augment.refreshClient((Player)player);
            }
        });
        ClientTickEvent.CLIENT_PRE.register(client -> {
            if (client.player != null && client.player.getMainHandItem().getItem() instanceof PortableLaserItem && laserActive) {
                NetworkManager.sendToServer(new PortableLaserItem.LaserPlayerUsePacket());
            } else {
                laserActive = false;
            }
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            ClientZiplineHandler.onClientTick();
            ZiplineFxHandler.tick();
        });
        ClientRawInputEvent.MOUSE_CLICKED_PRE.register((client, button, action, mods) -> OritechClient.handleMouseClicked(client, button, action, mods) ? EventResult.interruptTrue() : EventResult.pass());
        Oritech.LOGGER.info("Oritech client initialization done");
    }

    public static boolean handleMouseClicked(Minecraft client, int button, int action, int mods) {
        if (client.player != null && client.player.getMainHandItem().getItem() instanceof PortableLaserItem && button == 0 && client.screen == null) {
            laserActive = action == 1;
            return action == 1;
        }
        return false;
    }

    public static void registerRenderers() {
        Oritech.LOGGER.info("Registering oritech renderers");
        ModRenderers.registerRenderers();
    }
}

