/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spellbinder;

import alexthw.not_enough_glyphs.common.spellbinder.SpellBinder;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import org.jetbrains.annotations.NotNull;

public class SpellBinderContainer
extends AbstractContainerMenu {
    private final IItemHandler inventory;
    public final ItemStack binder;

    public SpellBinderContainer(int windowId, Inventory playerInv, ItemStack backpack) {
        this(Registry.SPELL_HOLDER.get(), windowId, playerInv, (IItemHandler)backpack.getCapability(Capabilities.ItemHandler.ITEM), backpack);
    }

    public SpellBinderContainer(MenuType<? extends SpellBinderContainer> containerType, int windowId, Inventory playerInv, IItemHandler inventory, ItemStack binder) {
        super(containerType, windowId);
        this.binder = binder;
        this.inventory = inventory;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                int index = i * 2 + j;
                this.addSlot(this.makeSlot(inventory, -8 + i * 23, (j % 2 == 0 ? -5 : 14) + j * 20, index));
            }
        }
        int pageoffset = 10;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = pageoffset + i * 3 + j;
                this.addSlot(this.makeSlot(inventory, -3 + i * 20, (switch (j) {
                    default -> 2;
                    case 1 -> 9;
                    case 2 -> 16;
                }) + (pageoffset + j) * 12, index));
            }
        }
        int offset = this.offset();
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInv, j1 + (l + 1) * 9, 8 + j1 * 18, offset + 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInv, i1, 8 + i1 * 18, offset + 142));
        }
    }

    @NotNull
    protected Slot makeSlot(IItemHandler inventory, int y, int x, int index) {
        return new ItemHandlerCopySlot(this, inventory, index, x, y){

            protected void setStackCopy(@NotNull ItemStack stack) {
                super.setStackCopy(stack);
            }

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() instanceof SpellParchment || stack.getItem() instanceof CasterTome;
            }

            public int getMaxStackSize(@NotNull ItemStack stack) {
                AbstractCaster parchmentCaster;
                if (stack.getItem() instanceof SpellParchment && (parchmentCaster = SpellCasterRegistry.from((ItemStack)stack)) != null && parchmentCaster.getSpell().isEmpty()) {
                    return super.getMaxStackSize(stack);
                }
                return 1;
            }
        };
    }

    public void removed(Player playerIn) {
        playerIn.level().playSound(null, playerIn.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        super.removed(playerIn);
    }

    public int offset() {
        return 50;
    }

    public boolean stillValid(@NotNull Player playerIn) {
        if (playerIn.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof SpellBinder) {
            return true;
        }
        return playerIn.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof SpellBinder;
    }

    @Nonnull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack = slot.getItem();
            copy = itemstack.copy();
            if (index < this.inventory.getSlots() ? !this.moveItemStackTo(itemstack, this.inventory.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(itemstack, 0, this.inventory.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }
}

