/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spellbinder;

import alexthw.not_enough_glyphs.client.SpellBinderRenderer;
import alexthw.not_enough_glyphs.common.network.OpenSpellBinderPacket;
import alexthw.not_enough_glyphs.common.network.PacketSetBinderSlot;
import alexthw.not_enough_glyphs.common.spell.BulldozeThread;
import alexthw.not_enough_glyphs.common.spell.RandomPerk;
import alexthw.not_enough_glyphs.common.spellbinder.BinderCasterData;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinderContainer;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellBinder
extends Item
implements ICasterTool,
GeoItem,
IRadialProvider,
ISpellModifierItem {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static AbstractCaster<?> getBinderCaster(ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        AbstractCaster binderCaster = SpellCasterRegistry.from((ItemStack)stack);
        if (inv != null && binderCaster != null) {
            for (int index = 0; index >= 0 && index < 10; ++index) {
                AbstractCaster caster;
                ItemStack stackInSlot = inv.getStackInSlot(index);
                binderCaster = stackInSlot.isEmpty() ? binderCaster.setSpell(new Spell(), index) : ((caster = SpellCasterRegistry.from((ItemStack)stackInSlot)) != null ? binderCaster.setSpell(caster.getSpell(), index) : binderCaster.setSpell(new Spell(), index));
            }
            binderCaster.saveToStack(stack);
            return binderCaster;
        }
        return binderCaster;
    }

    @javax.annotation.Nullable
    public static PerkInstance getPerkInstanceFromHands(IPerk perk, @NotNull LivingEntity entity) {
        PerkInstance highestHolder = null;
        int maxCount = 0;
        for (ItemStack stack : entity.getHandSlots()) {
            ArmorPerkHolder holder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (holder == null) continue;
            for (PerkInstance instance : holder.getPerkInstances(stack)) {
                if (instance.getPerk() != perk) continue;
                maxCount = Math.max(maxCount, instance.getSlot().value());
                highestHolder = instance;
            }
        }
        return highestHolder;
    }

    public boolean canQuickCast() {
        return true;
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        AbstractCaster caster = SpellCasterRegistry.from((ItemStack)pStack);
        if (caster == null || caster.getSpell().name().isEmpty()) {
            return super.getName(pStack);
        }
        String name = caster.getSpellName(caster.getCurrentSlot());
        return Component.literal((String)(super.getName(pStack).getString() + "(" + name + ")"));
    }

    public SpellBinder(Item.Properties pProperties) {
        super(pProperties.component((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder()).component((DataComponentType)Registry.SPELL_BINDER_CASTER.get(), (Object)new BinderCasterData(10)));
    }

    public void openContainer(ServerPlayer player, ItemStack bag) {
        SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new SpellBinderContainer(w, p, bag), bag.getHoverName());
        player.openMenu((MenuProvider)container, b -> b.writeBoolean(SpellBinder.getBookHand((Player)player) == InteractionHand.MAIN_HAND));
        player.level().playSound(null, player.blockPosition(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        AbstractCaster<?> caster = SpellBinder.getBinderCaster(stack);
        return caster.castSpell(pLevel, (LivingEntity)pPlayer, pUsedHand, (Component)Component.translatable((String)"ars_nouveau.invalid_spell"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onOpenBookMenuKeyPressed(ItemStack stack, Player player) {
        InteractionHand hand = SpellBinder.getBookHand(player);
        if (hand != null) {
            Networking.sendToServer((CustomPacketPayload)new OpenSpellBinderPacket(hand));
        }
    }

    @javax.annotation.Nullable
    public static InteractionHand getBookHand(Player playerEntity) {
        ItemStack mainStack = playerEntity.getMainHandItem();
        ItemStack offStack = playerEntity.getOffhandItem();
        return mainStack.getItem() instanceof SpellBinder ? InteractionHand.MAIN_HAND : (offStack.getItem() instanceof SpellBinder ? InteractionHand.OFF_HAND : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.getInstance().setScreen((Screen)new GuiRadialMenu(this.getRadialMenuProviderForSpellpart(stack)));
    }

    public RadialMenu<AbstractSpellPart> getRadialMenuProviderForSpellpart(ItemStack itemStack) {
        return new RadialMenu(slot -> Networking.sendToServer((CustomPacketPayload)new PacketSetBinderSlot(slot)), this.getRadialMenuSlotsForSpellpart(itemStack), RenderUtils::drawSpellPart, 0);
    }

    public List<RadialMenuSlot<AbstractSpellPart>> getRadialMenuSlotsForSpellpart(ItemStack itemStack) {
        AbstractCaster spellCaster = SpellCasterRegistry.from((ItemStack)itemStack);
        if (spellCaster == null) {
            return new ArrayList<RadialMenuSlot<AbstractSpellPart>>();
        }
        ArrayList<RadialMenuSlot<AbstractSpellPart>> radialMenuSlots = new ArrayList<RadialMenuSlot<AbstractSpellPart>>();
        for (int i = 0; i < spellCaster.getMaxSlots(); ++i) {
            Spell spell = spellCaster.getSpell(i);
            AbstractSpellPart primaryIcon = null;
            ArrayList<AbstractSpellPart> secondaryIcons = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart p : spell.recipe()) {
                if (p instanceof AbstractCastMethod) {
                    secondaryIcons.add(p);
                }
                if (!(p instanceof AbstractEffect)) continue;
                primaryIcon = p;
                break;
            }
            radialMenuSlots.add((RadialMenuSlot<AbstractSpellPart>)new RadialMenuSlot(spellCaster.getSpellName(i), primaryIcon, secondaryIcons));
        }
        return radialMenuSlots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        AbstractCaster caster = SpellCasterRegistry.from((ItemStack)stack);
        if (caster == null) {
            return;
        }
        if (!((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() || Screen.hasShiftDown() || caster.isSpellHidden() || caster.getSpell().isEmpty()) {
            this.getInformation(stack, context, tooltip, flag);
        }
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell_book.select", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.OPEN_RADIAL_HUD.getName()).get()}));
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell_binder.open", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.OPEN_BOOK.getName()).get()}));
        ArmorPerkHolder data = (ArmorPerkHolder)stack.get((Supplier)DataComponentRegistry.ARMOR_PERKS);
        if (data != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.book_slot").withStyle(ChatFormatting.GOLD));
            data.appendPerkTooltip(tooltip, stack);
        }
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (shooter != null) {
            PerkInstance randomPerk;
            PerkInstance slowPerk = SpellBinder.getPerkInstanceFromHands((IPerk)BulldozeThread.INSTANCE, shooter);
            if (slowPerk != null) {
                builder.addAccelerationModifier(-1.5f * (float)(slowPerk.getSlot().value() + 1));
            }
            if ((randomPerk = SpellBinder.getPerkInstanceFromHands((IPerk)RandomPerk.INSTANCE, shooter)) != null) {
                return RandomPerk.applyItemModifiers(builder, world, randomPerk.getSlot().value());
            }
        }
        return builder;
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 0.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
        if (perkHolder != null) {
            for (PerkInstance instance : perkHolder.getPerkInstances(stack)) {
                IPerk iPerk = instance.getPerk();
                if (!(iPerk instanceof IPerk)) continue;
                IPerk perk = iPerk;
                modifiers = perk.applyAttributeModifiers(modifiers, stack, instance.getSlot().value(), EquipmentSlotGroup.HAND);
            }
        }
        return modifiers;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            public static final BlockEntityWithoutLevelRenderer renderer = new SpellBinderRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return renderer;
            }
        });
    }
}

