/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.contingency;

import alexthw.not_enough_glyphs.api.ContingencyEffectInstance;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractContingency
extends AbstractEffect
implements IPotionEffect {
    public AbstractContingency(String effectName, String description) {
        super(CompatRL.neg(effectName), description);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            SpellContext newContext = spellContext.makeChildContext();
            SpellResolver newResolver = resolver.getNewResolver(newContext);
            spellContext.setCanceled(true);
            this.applyContingency(spellStats, livingEntity, newResolver);
        }
    }

    public void applyContingency(SpellStats spellStats, LivingEntity livingEntity, SpellResolver newResolver) {
        if (livingEntity.hasEffect(Registry.CONTINGENCY)) {
            livingEntity.removeEffectNoUpdate(Registry.CONTINGENCY);
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * spellStats.getDurationInTicks();
        livingEntity.addEffect((MobEffectInstance)new ContingencyEffectInstance(newResolver, this.getTrigger(), ticks, spellStats.getAmpMultiplier(), spellStats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE)));
    }

    public Integer getTypeIndex() {
        return 9;
    }

    public abstract ContingencyEffectInstance.TRIGGER getTrigger();

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    protected int getDefaultManaCost() {
        return 100;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentSplit.INSTANCE});
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.ABJURATION);
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 100 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 100 : (Integer)this.EXTEND_TIME.get();
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSplit.INSTANCE, "Increases the number of possible activations before the contingency ends by one.");
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 100);
        this.addExtendTimeConfig(builder, 50);
    }
}

