/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.generator.KubeResourceGenerator;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.plugin.builtin.event.ClientEvents;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualAssetPack;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.neoforged.fml.loading.FMLLoader;

public class ClientAssetPacks {
    public static final ClientAssetPacks INSTANCE = new ClientAssetPacks();
    public final VirtualAssetPack internalAssetPack = new VirtualAssetPack(GeneratedDataStage.INTERNAL, () -> RegistryAccessContainer.BUILTIN);
    public final Map<GeneratedDataStage, VirtualAssetPack> virtualPacks = GeneratedDataStage.forScripts(stage -> new VirtualAssetPack((GeneratedDataStage)((Object)stage), () -> RegistryAccessContainer.BUILTIN));

    public List<PackResources> inject(List<PackResources> original) {
        try {
            return this.inject0(original);
        }
        catch (Throwable ex) {
            ConsoleJS.CLIENT.error("Error while generating client assets", ex);
            return original;
        }
    }

    private List<PackResources> inject0(List<PackResources> original) {
        ArrayList<PackResources> packs = new ArrayList<PackResources>(original);
        ArrayList<PackResources> filePacks = new ArrayList<PackResources>();
        KubeFileResourcePack.scanAndLoad(KubeJSPaths.ASSETS, filePacks);
        filePacks.sort((p1, p2) -> p1.packId().compareToIgnoreCase(p2.packId()));
        filePacks.add(new KubeFileResourcePack(PackType.CLIENT_RESOURCES));
        int beforeModsIndex = KubeFileResourcePack.findBeforeModsIndex(packs);
        int afterModsIndex = KubeFileResourcePack.findAfterModsIndex(packs);
        packs.add(beforeModsIndex, this.virtualPacks.get((Object)GeneratedDataStage.BEFORE_MODS));
        packs.add(afterModsIndex, this.internalAssetPack);
        packs.add(afterModsIndex + 1, this.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        packs.addAll(afterModsIndex + 2, filePacks);
        packs.add(this.virtualPacks.get((Object)GeneratedDataStage.LAST));
        this.internalAssetPack.reset();
        for (BuilderBase<?> builder : RegistryObjectStorage.ALL_BUILDERS) {
            builder.generateAssets(this.internalAssetPack);
        }
        KubeJSPlugins.forEachPlugin(this.internalAssetPack, KubeJSPlugin::generateAssets);
        HashMap<LangKubeEvent.Key, String> langMap = new HashMap<LangKubeEvent.Key, String>();
        HashMap<String, LangKubeEvent> langEvents = new HashMap<String, LangKubeEvent>();
        LangKubeEvent enUsLangEvent = langEvents.computeIfAbsent("en_us", s -> new LangKubeEvent((String)s, (Map<LangKubeEvent.Key, String>)langMap));
        for (BuilderBase<?> builder : RegistryObjectStorage.ALL_BUILDERS) {
            builder.generateLang(enUsLangEvent);
        }
        KubeJSPlugins.forEachPlugin(enUsLangEvent, KubeJSPlugin::generateLang);
        ClientEvents.GENERATE_ASSETS.post(ScriptType.CLIENT, GeneratedDataStage.AFTER_MODS, this.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        for (String lang : ClientEvents.LANG.findUniqueExtraIds(ScriptType.CLIENT)) {
            String string = String.valueOf(lang);
            if (LangKubeEvent.PATTERN.matcher(string).matches()) {
                ClientEvents.LANG.post(ScriptType.CLIENT, string, langEvents.computeIfAbsent(string, k -> new LangKubeEvent((String)k, (Map<LangKubeEvent.Key, String>)langMap)));
                continue;
            }
            ConsoleJS.CLIENT.error("Invalid language key: " + string);
        }
        try {
            for (Path dir : Files.list(KubeJSPaths.ASSETS).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList()) {
                String string = dir.getFileName().toString();
                Path langDir = dir.resolve("lang");
                if (!Files.exists(langDir, new LinkOption[0]) || !Files.isDirectory(langDir, new LinkOption[0])) continue;
                for (Path path : Files.list(langDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).toList()) {
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(".json")) continue;
                    try {
                        BufferedReader reader = Files.newBufferedReader(path);
                        try {
                            JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                            String lang = fileName.substring(0, fileName.length() - 5);
                            for (Map.Entry entry : json.entrySet()) {
                                langMap.put(new LangKubeEvent.Key(string, lang, (String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap<String, Map> finalMap = new HashMap<String, Map>();
        for (Map.Entry entry : langMap.entrySet()) {
            Map ns = finalMap.computeIfAbsent(((LangKubeEvent.Key)entry.getKey()).namespace(), s -> new HashMap());
            JsonObject jsonObject = ns.computeIfAbsent(((LangKubeEvent.Key)entry.getKey()).lang(), s -> new JsonObject());
            jsonObject.addProperty(((LangKubeEvent.Key)entry.getKey()).key(), (String)entry.getValue());
        }
        for (Map.Entry entry : finalMap.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.internalAssetPack.json(ResourceLocation.parse((String)((String)entry.getKey() + ":lang/" + (String)entry2.getKey())), (JsonElement)entry2.getValue());
            }
        }
        for (VirtualAssetPack virtualAssetPack : this.virtualPacks.values()) {
            virtualAssetPack.reset();
            if (!ClientEvents.GENERATE_ASSETS.hasListeners(virtualAssetPack.stage)) continue;
            ClientEvents.GENERATE_ASSETS.post(ScriptType.CLIENT, virtualAssetPack.stage, virtualAssetPack);
        }
        for (PackResources packResources : packs) {
            if (!(packResources instanceof KubeResourceGenerator)) continue;
            KubeResourceGenerator generator = (KubeResourceGenerator)packResources;
            generator.flush();
        }
        if (!FMLLoader.isProduction()) {
            KubeJS.LOGGER.info("Loaded {} asset packs: {}", (Object)packs.size(), (Object)packs.stream().map(PackResources::packId).collect(Collectors.joining(", ")));
        }
        return packs;
    }
}

