/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui.screen;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class WarningScreen
extends Screen {
    protected final Screen parent;
    protected final Component message;
    protected int messageHeight;

    protected WarningScreen(Screen parent, Component title, Component message) {
        super(title);
        this.parent = parent;
        this.message = message;
    }

    protected void init() {
        super.init();
        this.messageHeight = this.font.wordWrapHeight((FormattedText)this.message, 300);
        this.addButtons(this.height / 2 + this.messageHeight / 2 + 15);
    }

    protected void addButtons(int y) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_PROCEED, b -> Minecraft.getInstance().setScreen(this.parent)).bounds(this.width / 2 - 100, y, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        MutableComponent mutableComponent = this.title.copy().withStyle(ChatFormatting.BOLD);
        int n = this.width / 2;
        int n2 = this.height / 2 - this.messageHeight / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawCenteredString(this.font, (Component)mutableComponent, n, n2 - 9 - 15, 0xFFAA00);
        MultiLineLabel.create((Font)this.font, (Component)this.message, (int)300).renderCentered(guiGraphics, this.width / 2, this.height / 2 - this.messageHeight / 2);
    }
}

