/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.client.gui.components;

import dev.aika.smsn.SMSN;
import dev.aika.smsn.annotation.RequiresRestart;
import dev.aika.smsn.utils.ComponentUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import lombok.Generated;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractComponentBuilder<T> {
    private static final Logger log = SMSN.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"AbstractComponentBuilder");
    protected final ConfigEntryBuilder entryBuilder;
    protected final Object configObject;
    protected Object defaultConfigObject;
    protected final Field field;
    private final int modifiers;
    protected String category;
    protected String modId;

    public AbstractComponentBuilder(ConfigEntryBuilder entryBuilder, Object configObject, Field field) {
        this.entryBuilder = entryBuilder;
        this.configObject = configObject;
        this.field = field;
        this.modifiers = field.getModifiers();
    }

    protected T getValue() {
        this.field.setAccessible(true);
        return (T)(Modifier.isStatic(this.modifiers) ? this.field.get(null) : this.field.get(this.configObject));
    }

    protected void setValue(T value) {
        if (Modifier.isFinal(this.modifiers)) {
            log.warn(marker, "Cannot set value of final field: {}", (Object)this.field.getName());
            return;
        }
        this.field.setAccessible(true);
        this.field.set(this.configObject, value);
    }

    protected T getDefaultValue() {
        Field _field;
        if (this.defaultConfigObject == null) {
            return this.getValue();
        }
        try {
            _field = this.defaultConfigObject.getClass().getDeclaredField(this.field.getName());
        }
        catch (NoSuchFieldException e) {
            return this.getValue();
        }
        _field.setAccessible(true);
        return (T)(Modifier.isStatic(this.modifiers) ? _field.get(null) : _field.get(this.defaultConfigObject));
    }

    protected String translatableKeyPrefix() {
        return String.format("config.%s.%s", this.modId, this.category);
    }

    protected Component fieldNameKey() {
        return Component.translatable((String)String.format("%s.%s", this.translatableKeyPrefix(), this.field.getName()));
    }

    protected <A extends AbstractConfigListEntry<T>, SELF extends FieldBuilder<T, A, SELF>> void fieldBuilderInit(AbstractFieldBuilder<T, A, SELF> builder) {
        String translationKey;
        if (this.defaultConfigObject != null) {
            builder.setDefaultValue(this.getDefaultValue());
        }
        if (ComponentUtils.hasTranslation(translationKey = String.format("%s.%s.@tooltip", this.translatableKeyPrefix(), this.field.getName()))) {
            builder.setTooltip(new Component[]{Component.translatable((String)translationKey)});
        }
        builder.requireRestart(this.field.getAnnotation(RequiresRestart.class) != null);
    }

    public abstract AbstractConfigListEntry<T> build();

    @Generated
    public AbstractComponentBuilder<T> setDefaultConfigObject(Object defaultConfigObject) {
        this.defaultConfigObject = defaultConfigObject;
        return this;
    }

    @Generated
    public AbstractComponentBuilder<T> setCategory(String category) {
        this.category = category;
        return this;
    }

    @Generated
    public AbstractComponentBuilder<T> setModId(String modId) {
        this.modId = modId;
        return this;
    }
}

