/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.loottables;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import us.drullk.umbralskies.loottables.UmbralLootModifiers;

public class ItemAdditionModifier
extends LootModifier {
    public static final MapCodec<ItemAdditionModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ItemStack.CODEC.listOf().fieldOf("stacks").forGetter(o -> o.additionalStacks)).apply((Applicative)instance, ItemAdditionModifier::new));
    private final List<ItemStack> additionalStacks;

    public ItemAdditionModifier(LootItemCondition[] conditions, ItemStack ... additionalStacks) {
        this(conditions, List.of(additionalStacks));
    }

    public ItemAdditionModifier(LootItemCondition[] conditions, List<ItemStack> additionalStacks) {
        super(conditions);
        this.additionalStacks = additionalStacks;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int overflow = generatedLoot.size() - 26;
        if (overflow > 0) {
            generatedLoot.removeElements(26, 26 + overflow);
        }
        for (ItemStack stack : this.additionalStacks) {
            generatedLoot.add((Object)stack.copy());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)UmbralLootModifiers.LOOT_ADDITION.get();
    }
}

