/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.world.placementmodifier.DungeonBlacklistFilter;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import twilightforest.TFRegistries;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.init.TFFeatures;
import twilightforest.util.woods.WoodPalette;
import twilightforest.world.components.feature.config.SwizzleConfig;
import us.drullk.umbralskies.UmbralKeys;
import us.drullk.umbralskies.block.UmbralBlocks;
import us.drullk.umbralskies.data.UmbralTags;

public class UmbralDataPack {
    static final RegistrySetBuilder DATA_BUILDER = new RegistrySetBuilder().add(TFRegistries.Keys.WOOD_PALETTES, UmbralDataPack::generateWoodPalettes).add(Registries.CONFIGURED_FEATURE, UmbralDataPack::generateFeatureConfigurations).add(Registries.PLACED_FEATURE, UmbralDataPack::generatePlacedFeatures).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, UmbralDataPack::generateBiomeModifiers);

    static void generateWoodPalettes(BootstrapContext<WoodPalette> context) {
        context.register(UmbralKeys.SKYROOT_PALETTE, (Object)new WoodPalette((Block)AetherBlocks.SKYROOT_PLANKS.get(), (Block)AetherBlocks.SKYROOT_STAIRS.get(), (Block)AetherBlocks.SKYROOT_SLAB.get(), (Block)AetherBlocks.SKYROOT_BUTTON.get(), (Block)AetherBlocks.SKYROOT_FENCE.get(), (Block)AetherBlocks.SKYROOT_FENCE_GATE.get(), (Block)AetherBlocks.SKYROOT_PRESSURE_PLATE.get(), (Block)UmbralBlocks.SKYROOT_BANISTER.get()));
    }

    static void generateFeatureConfigurations(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter woodPaletteGetter = context.lookup(TFRegistries.Keys.WOOD_PALETTES);
        WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> paletteList = UmbralDataPack.buildPaletteChoices((HolderGetter<WoodPalette>)woodPaletteGetter);
        ProcessorRule processorAetherDirt = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.DIRT), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)));
        ProcessorRule processorAetherGrass = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.GRASS_BLOCK), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)));
        ProcessorRule processorHolystone = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)));
        ProcessorRule processorLogs = new ProcessorRule((RuleTest)new TagMatchTest(BlockTags.LOGS), (RuleTest)AlwaysTrueTest.INSTANCE, ((RotatedPillarBlock)AetherBlocks.SKYROOT_LOG.get()).defaultBlockState());
        ProcessorRule cobble2HolystoneBlock = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.COBBLESTONE), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)));
        ProcessorRule cobble2HolystoneStair = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.COBBLESTONE_STAIRS), (RuleTest)AlwaysTrueTest.INSTANCE, ((StairBlock)AetherBlocks.HOLYSTONE_STAIRS.get()).defaultBlockState());
        ProcessorRule cobble2HolystoneSlab = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.COBBLESTONE_SLAB), (RuleTest)AlwaysTrueTest.INSTANCE, ((SlabBlock)AetherBlocks.HOLYSTONE_SLAB.get()).defaultBlockState());
        ProcessorRule cobble2HolystoneWall = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.COBBLESTONE_WALL), (RuleTest)AlwaysTrueTest.INSTANCE, ((WallBlock)AetherBlocks.HOLYSTONE_WALL.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolystoneBlock = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICKS), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolystoneStair = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_STAIRS), (RuleTest)AlwaysTrueTest.INSTANCE, ((StairBlock)AetherBlocks.HOLYSTONE_STAIRS.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolystoneSlab = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_SLAB), (RuleTest)AlwaysTrueTest.INSTANCE, ((SlabBlock)AetherBlocks.HOLYSTONE_SLAB.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolystoneWall = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_WALL), (RuleTest)AlwaysTrueTest.INSTANCE, ((WallBlock)AetherBlocks.HOLYSTONE_WALL.get()).defaultBlockState());
        ProcessorRule stoneChiseled2HolystoneBlock = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.CHISELED_STONE_BRICKS), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolyBrickBlock = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICKS), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AetherBlocks.HOLYSTONE_BRICKS.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolyBrickStair = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_STAIRS), (RuleTest)AlwaysTrueTest.INSTANCE, ((StairBlock)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolyBrickSlab = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_SLAB), (RuleTest)AlwaysTrueTest.INSTANCE, ((SlabBlock)AetherBlocks.HOLYSTONE_BRICK_SLAB.get()).defaultBlockState());
        ProcessorRule stoneBrick2HolyBrickWall = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.STONE_BRICK_WALL), (RuleTest)AlwaysTrueTest.INSTANCE, ((WallBlock)AetherBlocks.HOLYSTONE_BRICK_WALL.get()).defaultBlockState());
        ProcessorRule brick2HolyBlock = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.BRICKS), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AetherBlocks.HOLYSTONE_BRICKS.get()).defaultBlockState());
        ProcessorRule brick2HolyStair = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.BRICK_STAIRS), (RuleTest)AlwaysTrueTest.INSTANCE, ((StairBlock)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get()).defaultBlockState());
        ProcessorRule brick2HolySlab = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.BRICK_SLAB), (RuleTest)AlwaysTrueTest.INSTANCE, ((SlabBlock)AetherBlocks.HOLYSTONE_BRICK_SLAB.get()).defaultBlockState());
        ProcessorRule brick2HolyWall = new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.BRICK_WALL), (RuleTest)AlwaysTrueTest.INSTANCE, ((WallBlock)AetherBlocks.HOLYSTONE_BRICK_WALL.get()).defaultBlockState());
        ProcessorRule randomHolyMossBlock = new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.HOLYSTONE.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.MOSSY_HOLYSTONE.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)));
        ProcessorRule randomHolyMossStair = new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.HOLYSTONE_STAIRS.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((StairBlock)AetherBlocks.MOSSY_HOLYSTONE_STAIRS.get()).defaultBlockState());
        ProcessorRule randomHolyMossSlab = new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.HOLYSTONE_SLAB.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((SlabBlock)AetherBlocks.MOSSY_HOLYSTONE_SLAB.get()).defaultBlockState());
        ProcessorRule randomHolyMossWall = new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.HOLYSTONE_WALL.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((WallBlock)AetherBlocks.MOSSY_HOLYSTONE_WALL.get()).defaultBlockState());
        SwizzleConfig aetherHutSwizzle = SwizzleConfig.generate((HolderGetter)woodPaletteGetter, (TagKey)CustomTagGenerator.WoodPaletteTagGenerator.DRUID_HUT_SWIZZLE_MASK, paletteList, (ProcessorRule[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.ANDESITE), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.POLISHED_ANDESITE), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AetherBlocks.HOLYSTONE_BRICKS.get()).defaultBlockState()), new ProcessorRule((RuleTest)new TagMatchTest(BlockTags.LEAVES), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((Block)AetherBlocks.SKYROOT_LEAVES.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new TagMatchTest(BlockTags.FENCES), (RuleTest)AlwaysTrueTest.INSTANCE, ((FenceBlock)AetherBlocks.SKYROOT_FENCE.get()).defaultBlockState()), processorLogs, cobble2HolystoneBlock, cobble2HolystoneStair, cobble2HolystoneSlab, cobble2HolystoneWall, brick2HolyBlock, brick2HolyStair, brick2HolySlab, brick2HolyWall, stoneBrick2HolystoneBlock, stoneBrick2HolystoneStair, stoneBrick2HolystoneSlab, stoneBrick2HolystoneWall, randomHolyMossBlock, randomHolyMossStair, randomHolyMossSlab, randomHolyMossWall});
        context.register(UmbralKeys.AETHER_HUT_PALETTE, (Object)new ConfiguredFeature((Feature)TFFeatures.DRUID_HUT.get(), (FeatureConfiguration)aetherHutSwizzle));
        SwizzleConfig aetherSimpleWellSwizzle = SwizzleConfig.generate((HolderGetter)woodPaletteGetter, (TagKey)CustomTagGenerator.WoodPaletteTagGenerator.WELL_SWIZZLE_MASK, paletteList, (ProcessorRule[])new ProcessorRule[]{processorLogs, processorAetherDirt, processorAetherGrass, cobble2HolystoneBlock, cobble2HolystoneStair, cobble2HolystoneSlab, cobble2HolystoneWall, randomHolyMossBlock, randomHolyMossStair, randomHolyMossSlab, randomHolyMossWall});
        context.register(UmbralKeys.AETHER_SIMPLE_WELL_PALETTE, (Object)new ConfiguredFeature((Feature)TFFeatures.SIMPLE_WELL.get(), (FeatureConfiguration)aetherSimpleWellSwizzle));
        SwizzleConfig aetherFancyWellSwizzle = SwizzleConfig.generate((HolderGetter)woodPaletteGetter, (TagKey)CustomTagGenerator.WoodPaletteTagGenerator.WELL_SWIZZLE_MASK, paletteList, (ProcessorRule[])new ProcessorRule[]{processorLogs, processorAetherDirt, processorAetherGrass, processorHolystone, cobble2HolystoneBlock, cobble2HolystoneStair, cobble2HolystoneSlab, cobble2HolystoneWall, stoneBrick2HolyBrickBlock, stoneBrick2HolyBrickStair, stoneBrick2HolyBrickSlab, stoneBrick2HolyBrickWall, stoneChiseled2HolystoneBlock, randomHolyMossBlock, randomHolyMossStair, randomHolyMossSlab, randomHolyMossWall});
        context.register(UmbralKeys.AETHER_FANCY_WELL_PALETTE, (Object)new ConfiguredFeature((Feature)TFFeatures.FANCY_WELL.get(), (FeatureConfiguration)aetherFancyWellSwizzle));
        context.register(UmbralKeys.RANDOMIZED_AETHER_WELL, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(UmbralKeys.AETHER_FANCY_WELL_PALETTE), (PlacementModifier[])new PlacementModifier[0]), 0.05f)), PlacementUtils.inlinePlaced((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(UmbralKeys.AETHER_SIMPLE_WELL_PALETTE), (PlacementModifier[])new PlacementModifier[0]))));
    }

    private static void generatePlacedFeatures(BootstrapContext<PlacedFeature> context) {
        UmbralDataPack.depthChecked(context, 15, 15, UmbralKeys.AETHER_DRUID_HUT, UmbralKeys.AETHER_HUT_PALETTE);
        UmbralDataPack.depthChecked(context, 5, 15, UmbralKeys.PLACEABLE_AETHER_WELL, UmbralKeys.RANDOMIZED_AETHER_WELL);
    }

    private static void depthChecked(BootstrapContext<PlacedFeature> context, int dist, int depth, ResourceKey<PlacedFeature> aetherDruidHut, ResourceKey<ConfiguredFeature<?, ?>> aetherHutPalette) {
        int halfDist = dist >> 1;
        BlockPredicateFilter northTop = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -1, halfDist), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter southTop = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(dist, -1, halfDist), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter westTop = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(halfDist, -1, 0), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter eastTop = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(halfDist, -1, dist), UmbralTags.AETHER_WORLDGEN));
        int middle = -(depth >> 1);
        BlockPredicateFilter middleSolidCheck1 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, middle, 0), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter middleSolidCheck2 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(dist, middle, 0), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter middleSolidCheck3 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, middle, dist), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter middleSolidCheck4 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(dist, middle, dist), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter undergroundSolidCheck1 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -depth, 0), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter undergroundSolidCheck2 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(dist, -depth, 0), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter undergroundSolidCheck3 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -depth, dist), UmbralTags.AETHER_WORLDGEN));
        BlockPredicateFilter undergroundSolidCheck4 = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(dist, -depth, dist), UmbralTags.AETHER_WORLDGEN));
        context.register(aetherDruidHut, (Object)new PlacedFeature((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(aetherHutPalette), List.of(RarityFilter.onAverageOnceEvery((int)10), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, new DungeonBlacklistFilter(), northTop, southTop, westTop, eastTop, middleSolidCheck1, middleSolidCheck2, middleSolidCheck3, middleSolidCheck4, undergroundSolidCheck1, undergroundSolidCheck2, undergroundSolidCheck3, undergroundSolidCheck4)));
    }

    static void generateBiomeModifiers(BootstrapContext<BiomeModifier> context) {
        HolderSet.Named aetherBiomeTarget = context.lookup(Registries.BIOME).getOrThrow(AetherTags.Biomes.IS_AETHER);
        HolderSet.Named twilightFeatures = context.lookup(Registries.PLACED_FEATURE).getOrThrow(UmbralTags.ADDED_AETHER_FEATURES);
        context.register(UmbralKeys.AETHER_MODIFIER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)aetherBiomeTarget, (HolderSet)twilightFeatures, GenerationStep.Decoration.SURFACE_STRUCTURES));
    }

    public static WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> buildPaletteChoices(HolderGetter<WoodPalette> paletteHolders) {
        WeightedEntry.Wrapper skyroot = WeightedEntry.wrap((Object)HolderSet.direct((Holder[])new Holder[]{paletteHolders.getOrThrow(UmbralKeys.SKYROOT_PALETTE)}), (int)24);
        WeightedEntry.Wrapper treasure = WeightedEntry.wrap((Object)paletteHolders.getOrThrow(CustomTagGenerator.WoodPaletteTagGenerator.TREASURE_PALETTES), (int)1);
        return WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{skyroot, treasure});
    }
}

