/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import com.aetherteam.aether.block.AetherBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.TwilightForestMod;
import twilightforest.block.BanisterBlock;
import twilightforest.block.ClimbableHollowLogBlock;
import twilightforest.block.HorizontalHollowLogBlock;
import twilightforest.block.VerticalHollowLogBlock;
import twilightforest.enums.BanisterShape;
import twilightforest.enums.HollowLogVariants;
import us.drullk.umbralskies.UmbralKeys;
import us.drullk.umbralskies.block.UmbralBlocks;

public class UmbralBlockStateModels
extends BlockStateProvider {
    private static final ResourceLocation CUTOUT = ResourceLocation.withDefaultNamespace((String)"cutout");

    public UmbralBlockStateModels(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "umbral_skies", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.banister((BanisterBlock)UmbralBlocks.SKYROOT_BANISTER.get());
        BlockModelProvider models = this.models();
        this.simpleBlock((Block)UmbralBlocks.SLIDER_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        this.simpleBlock((Block)UmbralBlocks.VALKYRIE_QUEEN_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        this.simpleBlock((Block)UmbralBlocks.SUN_SPIRIT_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        this.simpleBlock((Block)UmbralBlocks.SLIDER_WALL_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        this.simpleBlock((Block)UmbralBlocks.VALKYRIE_WALL_QUEEN_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        this.simpleBlock((Block)UmbralBlocks.SUN_SPIRIT_WALL_TROPHY_BLOCK.get(), (ModelFile)models.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/skull")));
        ModelFile.ExistingModelFile horizontalHollowLog = models.getExistingFile(TwilightForestMod.prefix((String)"horizontal_hollow_log"));
        ModelFile.ExistingModelFile hollowLogMossGrass = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_moss_grass"));
        ModelFile.ExistingModelFile hollowLogMoss = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_moss"));
        ModelFile.ExistingModelFile hollowLogSnow = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_snow"));
        ModelFile.ExistingModelFile verticalHollowLog = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log"));
        ModelFile.ExistingModelFile verticalHollowLogVine = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log_vine"));
        ModelFile.ExistingModelFile verticalHollowLogLadder = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log_ladder"));
        this.aetherHollowLogs((DeferredHolder<Block, RotatedPillarBlock>)AetherBlocks.SKYROOT_LOG, (DeferredHolder<Block, RotatedPillarBlock>)AetherBlocks.STRIPPED_SKYROOT_LOG, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"block/natural/skyroot_log_top"), UmbralBlocks.HOLLOW_SKYROOT_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_VERTICAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_CLIMBABLE, (ModelFile)horizontalHollowLog, (ModelFile)hollowLogMossGrass, (ModelFile)hollowLogMoss, (ModelFile)hollowLogSnow, (ModelFile)verticalHollowLog, (ModelFile)verticalHollowLogVine, (ModelFile)verticalHollowLogLadder);
        this.aetherHollowLogs((DeferredHolder<Block, RotatedPillarBlock>)AetherBlocks.GOLDEN_OAK_LOG, (DeferredHolder<Block, RotatedPillarBlock>)AetherBlocks.STRIPPED_SKYROOT_LOG, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"block/natural/skyroot_log_top"), UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_VERTICAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE, (ModelFile)horizontalHollowLog, (ModelFile)hollowLogMossGrass, (ModelFile)hollowLogMoss, (ModelFile)hollowLogSnow, (ModelFile)verticalHollowLog, (ModelFile)verticalHollowLogVine, (ModelFile)verticalHollowLogLadder);
    }

    private void banister(BanisterBlock banister) {
        this.getVariantBuilder((Block)banister).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)BanisterBlock.FACING);
            int yRot = (int)facing.toYRot();
            String extended = (Boolean)state.getValue((Property)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)state.getValue((Property)BanisterBlock.SHAPE)).getSerializedName() + extended;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/" + this.getBlockName((Block)banister) + "_" + variant, TwilightForestMod.prefix((String)("banister_" + variant)))).texture("texture", UmbralKeys.SKYROOT_BANISTER_TEX)).rotationY(yRot).build();
        }, new Property[]{BanisterBlock.WATERLOGGED});
    }

    private void aetherHollowLogs(DeferredHolder<Block, RotatedPillarBlock> originalLog, DeferredHolder<Block, RotatedPillarBlock> strippedLog, ResourceLocation top, DeferredHolder<Block, HorizontalHollowLogBlock> horizontalHollowLog, DeferredHolder<Block, VerticalHollowLogBlock> verticalHollowLog, DeferredHolder<Block, ClimbableHollowLogBlock> climbableHollowLog, ModelFile emptyLog, ModelFile mossLog, ModelFile grassLog, ModelFile snowLog, ModelFile hollowLog, ModelFile vineLog, ModelFile ladderLog) {
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)("block/natural/" + originalLog.getId().getPath()));
        ResourceLocation inner = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)("block/natural/" + strippedLog.getId().getPath()));
        this.getVariantBuilder((Block)horizontalHollowLog.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)(switch ((HollowLogVariants.Horizontal)state.getValue((Property)HorizontalHollowLogBlock.VARIANT)) {
                case HollowLogVariants.Horizontal.MOSS -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().getPath() + "_moss")).parent(mossLog);
                case HollowLogVariants.Horizontal.MOSS_AND_GRASS -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().getPath() + "_moss_grass")).parent(grassLog);
                case HollowLogVariants.Horizontal.SNOW -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().getPath() + "_snow")).parent(snowLog);
                default -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().getPath())).parent(emptyLog);
            }).renderType(CUTOUT)).texture("top", top)).texture("side", side)).texture("inner", inner)).rotationY(state.getValue((Property)HorizontalHollowLogBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0).build();
        });
        this.simpleBlock((Block)verticalHollowLog.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(verticalHollowLog.getId().getPath())).parent(hollowLog)).texture("top", top)).texture("side", side)).texture("inner", inner));
        this.getVariantBuilder((Block)climbableHollowLog.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)(switch ((HollowLogVariants.Climbable)state.getValue((Property)ClimbableHollowLogBlock.VARIANT)) {
                default -> throw new MatchException(null, null);
                case HollowLogVariants.Climbable.VINE -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(climbableHollowLog.getId().getPath() + "_vine")).parent(vineLog);
                case HollowLogVariants.Climbable.LADDER, HollowLogVariants.Climbable.LADDER_WATERLOGGED -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(climbableHollowLog.getId().getPath() + "_ladder")).parent(ladderLog);
            }).renderType(CUTOUT)).texture("top", top)).texture("side", side)).texture("inner", inner)).rotationY((int)((Direction)state.getValue((Property)ClimbableHollowLogBlock.FACING)).toYRot()).uvLock(true).build();
        });
    }

    private String getBlockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }
}

