/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.block.ClimbableHollowLogBlock;
import twilightforest.block.HorizontalHollowLogBlock;
import twilightforest.block.VerticalHollowLogBlock;
import twilightforest.enums.HollowLogVariants;
import twilightforest.init.TFBlocks;
import us.drullk.umbralskies.block.FloorAetherTrophyBlock;
import us.drullk.umbralskies.block.UmbralBlocks;
import us.drullk.umbralskies.block.WallAetherTrophyBlock;
import us.drullk.umbralskies.item.AetherTrophyItem;
import us.drullk.umbralskies.item.UmbralItems;

public class UmbralBlockLoot
extends BlockLootSubProvider {
    public UmbralBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf((Block)UmbralBlocks.SKYROOT_BANISTER.get());
        this.hollowLogs(UmbralBlocks.HOLLOW_SKYROOT_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_VERTICAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_CLIMBABLE);
        this.hollowLogs(UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_VERTICAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE);
        this.trophy(UmbralItems.SLIDER_TROPHY, UmbralBlocks.SLIDER_TROPHY_BLOCK, UmbralBlocks.SLIDER_WALL_TROPHY_BLOCK);
        this.trophy(UmbralItems.VALKYRIE_QUEEN_TROPHY, UmbralBlocks.VALKYRIE_QUEEN_TROPHY_BLOCK, UmbralBlocks.VALKYRIE_WALL_QUEEN_TROPHY_BLOCK);
        this.trophy(UmbralItems.SUN_SPIRIT_TROPHY, UmbralBlocks.SUN_SPIRIT_TROPHY_BLOCK, UmbralBlocks.SUN_SPIRIT_WALL_TROPHY_BLOCK);
    }

    private void trophy(DeferredHolder<Item, AetherTrophyItem> itemTrophy, DeferredHolder<Block, FloorAetherTrophyBlock> floorTrophy, DeferredHolder<Block, WallAetherTrophyBlock> wallTrophy) {
        LootTable.Builder table = this.createSingleItemTable((ItemLike)itemTrophy.get());
        this.add((Block)floorTrophy.get(), table);
        this.add((Block)wallTrophy.get(), table);
    }

    private void hollowLogs(DeferredHolder<Block, HorizontalHollowLogBlock> horizontalLog, DeferredHolder<Block, VerticalHollowLogBlock> verticalLog, DeferredHolder<Block, ClimbableHollowLogBlock> climbable) {
        this.add((Block)horizontalLog.get(), this.horizontalHollowLog((HorizontalHollowLogBlock)horizontalLog.get()));
        this.add((Block)verticalLog.get(), this.verticalHollowLog((VerticalHollowLogBlock)verticalLog.get()));
        this.add((Block)climbable.get(), this.climbableHollowLog((ClimbableHollowLogBlock)climbable.get()));
    }

    private LootTable.Builder horizontalHollowLog(HorizontalHollowLogBlock log) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)log.asItem()).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.SHORT_GRASS).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HorizontalHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Horizontal.MOSS_AND_GRASS))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TFBlocks.MOSS_PATCH.get())).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HorizontalHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Horizontal.MOSS_AND_GRASS))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TFBlocks.MOSS_PATCH.get())).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HorizontalHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Horizontal.MOSS))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNOWBALL).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HorizontalHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Horizontal.SNOW)))));
    }

    private LootTable.Builder verticalHollowLog(VerticalHollowLogBlock log) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)log.asItem()).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
    }

    private LootTable.Builder climbableHollowLog(ClimbableHollowLogBlock log) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)log.asItem()).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.VINE).when(this.hasSilkTouch())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ClimbableHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Climbable.VINE))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Blocks.LADDER).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ClimbableHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Climbable.LADDER))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Blocks.LADDER).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)log).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ClimbableHollowLogBlock.VARIANT, (Comparable)HollowLogVariants.Climbable.LADDER_WATERLOGGED)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        Stream iterator = BuiltInRegistries.BLOCK.stream();
        return iterator.filter(entry -> "umbral_skies".equals(entry.builtInRegistryHolder().key().location().getNamespace())).toList();
    }
}

