/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.client;

import com.aetherteam.aether.client.renderer.accessory.GlovesRenderer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import us.drullk.umbralskies.UmbralSkies;
import us.drullk.umbralskies.block.UmbralBlocks;
import us.drullk.umbralskies.client.renderer.AccessoriesHeadRenderer;
import us.drullk.umbralskies.client.renderer.EmissiveGlovesRenderer;
import us.drullk.umbralskies.client.renderer.SliderTrophyRenderer;
import us.drullk.umbralskies.client.renderer.SunSpiritTrophyRenderer;
import us.drullk.umbralskies.client.renderer.UmbralWithoutLevelRenderer;
import us.drullk.umbralskies.client.renderer.ValkyrieQueenTrophyRenderer;
import us.drullk.umbralskies.item.AetherTrophyItem;
import us.drullk.umbralskies.item.UmbralItems;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class UmbralClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)UmbralBlocks.SLIDER_TROPHY_ENTITY.get()), SliderTrophyRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)UmbralBlocks.VALKYRIE_TROPHY_ENTITY.get()), ValkyrieQueenTrophyRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)UmbralBlocks.SUN_SPIRIT_TROPHY_ENTITY.get()), SunSpiritTrophyRenderer::new);
        UmbralClient.registerCuriosRenderers();
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)UmbralSkies.prefix("item/trophy_bronze")));
    }

    @SubscribeEvent
    public static void registerExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(UmbralWithoutLevelRenderer.ITEM_EXTENSION, new Holder[]{UmbralItems.SLIDER_TROPHY, UmbralItems.VALKYRIE_QUEEN_TROPHY, UmbralItems.SUN_SPIRIT_TROPHY});
        event.registerItem(new IClientItemExtensions(){

            public int getDefaultDyeColor(ItemStack stack) {
                return -4337703;
            }
        }, new Holder[]{UmbralItems.ARCTIC_GLOVES});
    }

    private static void registerCuriosRenderers() {
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.NAGA_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.IRONWOOD_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.FIERY_GLOVES.get()), EmissiveGlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.STEELEAF_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.KNIGHTMETAL_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.PHANTOM_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.ARCTIC_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.YETI_GLOVES.get()), GlovesRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.SLIDER_TROPHY.get()), AccessoriesHeadRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.VALKYRIE_QUEEN_TROPHY.get()), AccessoriesHeadRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)((Item)UmbralItems.SUN_SPIRIT_TROPHY.get()), AccessoriesHeadRenderer::new);
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class Events {
        @SubscribeEvent
        public static void renderLiving(RenderLivingEvent.Pre<?, ?> event) {
            ItemStack stack = event.getEntity().getItemBySlot(EquipmentSlot.HEAD);
            if (!Events.stackIsTrophy(stack)) {
                return;
            }
            EntityModel entityModel = event.getRenderer().getModel();
            if (!(entityModel instanceof HeadedModel)) {
                return;
            }
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.getHead().visible = false;
            if (!(headedModel instanceof HumanoidModel)) {
                return;
            }
            HumanoidModel humanoidModel = (HumanoidModel)headedModel;
            humanoidModel.hat.visible = false;
        }

        private static boolean stackIsTrophy(ItemStack stack) {
            return stack.getItem() instanceof AetherTrophyItem;
        }
    }
}

