/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import us.drullk.umbralskies.block.AbstractAetherTrophyBlock;
import us.drullk.umbralskies.block.entity.AetherTrophyEntity;

public class WallAetherTrophyBlock
extends AbstractAetherTrophyBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape NORTH = Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    protected static final VoxelShape WEST = Block.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);

    public WallAetherTrophyBlock(BlockBehaviour.Properties properties, @Nullable Supplier<SoundEvent> clickSound, Supplier<BlockEntityType<AetherTrophyEntity>> blockEntityType) {
        super(properties, clickSound, blockEntityType);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] nearestOrderedDirections;
        BlockState blockstate = super.getStateForPlacement(context);
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : nearestOrderedDirections = context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal()) continue;
            blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (blockgetter.getBlockState(blockpos.relative(direction)).canBeReplaced(context)) continue;
            return blockstate;
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }
}

