/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import us.drullk.umbralskies.block.entity.AetherTrophyEntity;

public abstract class AbstractAetherTrophyBlock
extends BaseEntityBlock {
    private final MapCodec<AbstractAetherTrophyBlock> codec;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    @Nullable
    private final Supplier<SoundEvent> clickSound;
    public final Supplier<BlockEntityType<AetherTrophyEntity>> blockEntityType;

    protected AbstractAetherTrophyBlock(BlockBehaviour.Properties properties, @Nullable Supplier<SoundEvent> clickSound, Supplier<BlockEntityType<AetherTrophyEntity>> blockEntityType) {
        super(properties);
        this.clickSound = clickSound;
        this.blockEntityType = blockEntityType;
        this.codec = MapCodec.unit((Object)((Object)this));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().create(pos, state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.isClientSide() && (flag = level.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            if (flag) {
                this.playSound(level, pos);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        this.playSound(level, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void playSound(Level level, BlockPos pos) {
        if (!level.isClientSide() && this.clickSound != null) {
            level.playSound(null, pos, this.clickSound.get(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }
}

