/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies;

import com.google.common.base.Suppliers;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import twilightforest.events.CharmEvents;
import us.drullk.umbralskies.UmbralSkies;

public class AccessoriesCompat {
    public static final String ACCESSORIES = "UmbralSkiesCharmAccessories";
    public static String FIND_CLASS = "io.wispforest.accessories.impl.AccessoriesHolderImpl$EntityAttribute";
    public static Supplier<Constructor<?>> ENTITY_ATTRIBUTE_CONSTRUCTOR = Suppliers.memoize(() -> {
        try {
            Constructor<?> constructor = Class.forName(FIND_CLASS).getDeclaredConstructor(LivingEntity.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            UmbralSkies.LOGGER.error("Errored trying to instantiate {}", (Object)FIND_CLASS, (Object)e);
            throw new RuntimeException(e);
        }
    });

    public static void onCharmKeeping(Player player) {
        AccessoriesHolder accessoriesHolder = AccessoriesCapability.get((LivingEntity)player).getHolder();
        if (!(accessoriesHolder instanceof AccessoriesHolderImpl)) {
            return;
        }
        AccessoriesHolderImpl accessoriesHolder2 = (AccessoriesHolderImpl)accessoriesHolder;
        NbtMapCarrier carrier = NbtMapCarrier.of();
        accessoriesHolder2.write((MapCarrier)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)player.level().registryAccess())}));
        CharmEvents.getPlayerData((Player)player).put(ACCESSORIES, (Tag)carrier.compoundTag());
        accessoriesHolder2.getSlotContainers().forEach((name, container) -> container.getAccessories().removeAllItems());
    }

    public static void onKeepsakeCasket(Player player, int casketCapacity, List<ItemStack> list) {
        AccessoriesHolder accessoriesHolder = AccessoriesCapability.get((LivingEntity)player).getHolder();
        if (!(accessoriesHolder instanceof AccessoriesHolderImpl)) {
            return;
        }
        AccessoriesHolderImpl accessoriesHolder2 = (AccessoriesHolderImpl)accessoriesHolder;
        Set entries = accessoriesHolder2.getSlotContainers().entrySet();
        for (Map.Entry entry : entries) {
            AccessoriesCompat.moveItemsToCasket(casketCapacity, list, ((AccessoriesContainer)entry.getValue()).getAccessories());
        }
        for (Map.Entry entry : entries) {
            AccessoriesCompat.moveItemsToCasket(casketCapacity, list, ((AccessoriesContainer)entry.getValue()).getCosmeticAccessories());
        }
    }

    private static void moveItemsToCasket(int casketCapacity, List<ItemStack> casketInventory, ExpandedSimpleContainer accessories) {
        for (int containerIndex = 0; containerIndex < accessories.getContainerSize() && casketInventory.size() < casketCapacity - 1; ++containerIndex) {
            ItemStack item = accessories.getItem(containerIndex);
            if (item.isEmpty()) continue;
            AccessoriesCompat.addItemToList(item, casketInventory);
            accessories.setItem(containerIndex, item);
        }
    }

    public static void addItemToList(ItemStack insert, List<ItemStack> casketInventory) {
        for (int slotIndex = 0; slotIndex < casketInventory.size(); ++slotIndex) {
            ItemStack inventoryStack = casketInventory.get(slotIndex);
            if (inventoryStack.isEmpty()) {
                casketInventory.set(slotIndex, insert.copy());
                insert.setCount(0);
                return;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)insert, (ItemStack)inventoryStack)) continue;
            int maxStackSize = inventoryStack.getMaxStackSize();
            if (maxStackSize >= insert.getCount() + inventoryStack.getCount()) {
                inventoryStack.setCount(inventoryStack.getCount() + insert.getCount());
                insert.setCount(0);
                return;
            }
            int canInsert = Math.min(maxStackSize - inventoryStack.getCount(), insert.getCount());
            inventoryStack.setCount(inventoryStack.getCount() + canInsert);
            insert.shrink(canInsert);
            if (!insert.isEmpty()) continue;
            return;
        }
    }

    public static void returnStoredItems(Player player) {
        AccessoriesHolderImpl accessoriesHolder;
        AccessoriesHolder accessoriesHolder2;
        block3: {
            block2: {
                accessoriesHolder2 = AccessoriesCapability.get((LivingEntity)player).getHolder();
                if (!(accessoriesHolder2 instanceof AccessoriesHolderImpl)) break block2;
                accessoriesHolder = (AccessoriesHolderImpl)accessoriesHolder2;
                accessoriesHolder2 = CharmEvents.getPlayerData((Player)player).get(ACCESSORIES);
                if (accessoriesHolder2 instanceof CompoundTag) break block3;
            }
            return;
        }
        CompoundTag tag = (CompoundTag)accessoriesHolder2;
        accessoriesHolder.read((LivingEntity)player, (MapCarrier)new NbtMapCarrier(tag), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{AccessoriesCompat.nastyReflection((LivingEntity)player), RegistriesAttribute.of((RegistryAccess)player.level().registryAccess())}));
        CharmEvents.getPlayerData((Player)player).remove(ACCESSORIES);
    }

    private static SerializationAttribute.Instance nastyReflection(LivingEntity player) {
        try {
            return (SerializationAttribute.Instance)ENTITY_ATTRIBUTE_CONSTRUCTOR.get().newInstance(player);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            UmbralSkies.LOGGER.error("Error while trying to instantiate {}", (Object)FIND_CLASS, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

