/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import dev.technici4n.moderndynamics.MdBlock;
import dev.technici4n.moderndynamics.init.MdTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

public class WrenchHelper {
    public static boolean isWrench(ItemStack stack) {
        return stack.is(MdTags.WRENCHES);
    }

    public static void handleEvent(UseItemOnBlockEvent e) {
        if (e.getUsePhase() != UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK) {
            return;
        }
        UseOnContext context = e.getUseOnContext();
        Player player = context.getPlayer();
        if (player == null) {
            return;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (player.isSpectator() || !player.isShiftKeyDown() || !world.mayInteract(player, pos) || !WrenchHelper.isWrench(player.getItemInHand(context.getHand()))) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof MdBlock) {
            BlockEntity entity = world.getBlockEntity(pos);
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (!player.isCreative()) {
                Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
            }
            SoundType group = state.getSoundType();
            world.playSound(player, pos, group.getBreakSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
            e.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)world.isClientSide));
        }
    }
}

