/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test;

import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.test.MdGameTest;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import dev.technici4n.moderndynamics.util.FluidVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="moderndynamics")
@PrefixGameTestTemplate(value=false)
public class FluidTransferTest {
    @MdGameTest
    public void cauldronToCauldronExtractor(MdGameTestHelper helper) {
        BlockPos toFillPos = new BlockPos(0, 1, 0);
        BlockPos toEmptyPos = new BlockPos(3, 1, 0);
        helper.setBlock(toFillPos, Blocks.CAULDRON);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.FLUID_PIPE);
        helper.pipe(new BlockPos(2, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.EAST, MdItems.EXTRACTOR);
        helper.setBlock(toEmptyPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        int timeToFill = (int)Math.ceil(50.0);
        helper.succeedOnTickWhen(timeToFill, () -> helper.checkFluid(toFillPos, (Fluid)Fluids.WATER, 1000));
    }

    @MdGameTest
    public void cauldronToCauldronAttractor(MdGameTestHelper helper) {
        BlockPos toFillPos = new BlockPos(0, 1, 0);
        BlockPos toEmptyPos = new BlockPos(3, 1, 0);
        helper.setBlock(toFillPos, Blocks.CAULDRON);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.WEST, MdItems.ATTRACTOR);
        helper.pipe(new BlockPos(2, 1, 0), MdBlocks.FLUID_PIPE);
        helper.setBlock(toEmptyPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        int timeToFill = (int)Math.ceil(50.0);
        helper.succeedOnTickWhen(timeToFill, () -> helper.checkFluid(toFillPos, (Fluid)Fluids.WATER, 1000));
    }

    @MdGameTest(required=false)
    public void cauldronToCauldronAttractorExtractor(MdGameTestHelper helper) {
        BlockPos toFillPos = new BlockPos(0, 1, 0);
        BlockPos toEmptyPos = new BlockPos(3, 1, 0);
        helper.setBlock(toFillPos, Blocks.CAULDRON);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.WEST, MdItems.ATTRACTOR);
        helper.pipe(new BlockPos(2, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.EAST, MdItems.EXTRACTOR);
        helper.setBlock(toEmptyPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        int timeToFill = (int)Math.ceil(33.333333333333336);
        helper.succeedOnTickWhen(timeToFill, () -> helper.checkFluid(toFillPos, (Fluid)Fluids.WATER, 1000));
    }

    @MdGameTest
    public void doubleAttractor(MdGameTestHelper helper) {
        BlockPos toFillPos = new BlockPos(0, 1, 0);
        BlockPos toEmptyPos = new BlockPos(3, 1, 0);
        helper.setBlock(toFillPos, Blocks.CAULDRON);
        helper.setBlock(1, 1, 1, Blocks.LAVA_CAULDRON);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.WEST, MdItems.ATTRACTOR).attachment(Direction.SOUTH, MdItems.ATTRACTOR);
        helper.pipe(new BlockPos(2, 1, 0), MdBlocks.FLUID_PIPE);
        helper.setBlock(toEmptyPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        int timeToFill = (int)Math.ceil(25.0);
        helper.succeedOnTickWhen(timeToFill, () -> helper.checkFluid(toFillPos, (Fluid)Fluids.WATER, 1000));
    }

    @MdGameTest
    public void doubleAttractorOneFiltered(MdGameTestHelper helper) {
        BlockPos toFillPos = new BlockPos(0, 1, 0);
        BlockPos toEmptyPos = new BlockPos(3, 1, 0);
        helper.setBlock(toFillPos, Blocks.CAULDRON);
        helper.setBlock(1, 1, 1, Blocks.LAVA_CAULDRON);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.FLUID_PIPE).attachment(Direction.WEST, MdItems.ATTRACTOR).attachment(Direction.SOUTH, MdItems.ATTRACTOR).configureFluidIo(Direction.SOUTH, io -> {
            io.setFilterInversion(FilterInversionMode.WHITELIST);
            io.setFilter(0, FluidVariant.of((Fluid)Fluids.LAVA));
        });
        helper.pipe(new BlockPos(2, 1, 0), MdBlocks.FLUID_PIPE);
        helper.setBlock(toEmptyPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        int timeToFill = (int)Math.ceil(50.0);
        helper.succeedOnTickWhen(timeToFill, () -> helper.checkFluid(toFillPos, (Fluid)Fluids.WATER, 1000));
    }
}

