/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.shared;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import dev.technici4n.moderndynamics.network.TickHelper;
import net.minecraft.core.Direction;

public class TransferLimits {
    private static final int MAX_TICK_DIFF = 20;
    private static final int MAX_BUFFER_FACTOR = 50;
    private long lastUpdateTick = 0L;
    private final int[] available = new int[6];
    private final LimitSupplier limitSupplier;
    private final int maxBuffer;

    public TransferLimits(LimitSupplier limitSupplier, int maxBuffer) {
        this.limitSupplier = limitSupplier;
        this.maxBuffer = maxBuffer;
    }

    private void checkForNewTick() {
        long currentTick = TickHelper.getTickCounter();
        if (currentTick != this.lastUpdateTick) {
            if (this.maxBuffer <= 0 || this.lastUpdateTick == 0L) {
                for (Direction dir : Direction.values()) {
                    int i = dir.get3DDataValue();
                    this.available[i] = this.limitSupplier.getLimit(dir);
                }
            } else {
                long tickDiff = currentTick - this.lastUpdateTick;
                for (Direction dir : Direction.values()) {
                    int i = dir.get3DDataValue();
                    int tickLimit = this.limitSupplier.getLimit(dir);
                    if (tickLimit > 0) {
                        int potentialBuffer = Math.min(Ints.saturatedCast((long)((long)this.available[i] + (long)tickLimit * tickDiff)), this.maxBuffer);
                        this.available[i] = Math.max(potentialBuffer, tickLimit);
                        continue;
                    }
                    this.available[i] = 0;
                }
            }
            this.lastUpdateTick = currentTick;
        }
    }

    public int limit(int side, int amount) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0);
        this.checkForNewTick();
        if (this.limitSupplier.getLimit(Direction.from3DDataValue((int)side)) == 0) {
            return 0;
        }
        return Math.min(this.available[side], amount);
    }

    public void use(int side, int amount) {
        int n = side;
        this.available[n] = this.available[n] - amount;
    }

    @FunctionalInterface
    public static interface LimitSupplier {
        public int getLimit(Direction var1);
    }
}

