/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.energy;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.energy.EnergyCache;
import dev.technici4n.moderndynamics.network.energy.EnergyPipeTier;
import dev.technici4n.moderndynamics.network.shared.TransferLimits;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyHost
extends NodeHost {
    private static final NetworkManager<EnergyHost, EnergyCache> MANAGER = NetworkManager.get(EnergyCache.class, EnergyCache::new);
    private final EnergyPipeTier tier;
    private int energy;
    private final TransferLimits insertLimit = new TransferLimits(this::getTransferLimit, 0);
    private final TransferLimits extractLimit = new TransferLimits(this::getTransferLimit, 0);
    private final IEnergyStorage[] caps = new IEnergyStorage[6];
    private final IEnergyStorage unsidedCap = new ReadOnlyNetworkStorage(this);

    public EnergyHost(PipeBlockEntity pipe, EnergyPipeTier tier) {
        super(pipe);
        this.tier = tier;
        for (int i = 0; i < 6; ++i) {
            this.caps[i] = new NetworkEnergyStorage(i);
        }
    }

    @Override
    public NetworkManager<EnergyHost, EnergyCache> getManager() {
        return MANAGER;
    }

    @Override
    public Object getApiInstance(BlockCapability<?, Direction> lookup, @Nullable Direction side) {
        if (lookup == Capabilities.EnergyStorage.BLOCK) {
            if (side == null) {
                return this.unsidedCap;
            }
            if ((this.pipe.connectionBlacklist & 1 << side.get3DDataValue()) == 0) {
                return this.caps[side.get3DDataValue()];
            }
        }
        return null;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxEnergy() {
        return this.tier.getCapacity();
    }

    public void setEnergy(int energy) {
        if (energy < 0 || energy > this.getMaxEnergy()) {
            throw new IllegalArgumentException("Invalid energy value " + energy);
        }
        this.energy = energy;
        this.pipe.setChanged();
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canConnectTo(Direction connectionDirection, NodeHost adjacentHost) {
        return super.canConnectTo(connectionDirection, adjacentHost) && ((EnergyHost)adjacentHost).tier == this.tier;
    }

    protected void addEnergyStorages(List<IEnergyStorage> out) {
        this.gatherCapabilities(out);
    }

    public void gatherCapabilities(@Nullable List<IEnergyStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            Direction dir = Direction.from3DDataValue((int)i);
            IEnergyStorage adjacentCap = (IEnergyStorage)this.pipe.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, this.pipe.getBlockPos().relative(dir), (Object)dir.getOpposite());
            if (adjacentCap != null) {
                if (out == null) continue;
                out.add(new ExternalEnergyStorage(adjacentCap, i));
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeNbt(tag, registries);
        tag.putInt("energy", this.energy);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.readNbt(tag, registries);
        this.energy = Math.max(0, Math.min(tag.getInt("energy"), this.getMaxEnergy()));
    }

    private int getTransferLimit(Direction side) {
        return this.tier.getMaxConnectionTransfer();
    }

    private class ReadOnlyNetworkStorage
    extends AbstractNetworkStorage {
        private ReadOnlyNetworkStorage(EnergyHost energyHost) {
        }

        public int receiveEnergy(int maxAmount, boolean simulate) {
            return 0;
        }

        public boolean canReceive() {
            return false;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }
    }

    private class NetworkEnergyStorage
    extends AbstractNetworkStorage {
        private final int directionId;

        private NetworkEnergyStorage(int directionId) {
            this.directionId = directionId;
        }

        public boolean canExtract() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            return node != null && node.getHost() == EnergyHost.this;
        }

        public boolean canReceive() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            return node != null && node.getHost() == EnergyHost.this;
        }

        public int receiveEnergy(int maxAmount, boolean simulate) {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                if ((maxAmount = EnergyHost.this.extractLimit.limit(this.directionId, maxAmount)) <= 0) {
                    return 0;
                }
                int transferred = ((EnergyCache)node.getNetworkCache()).insert(maxAmount, simulate);
                if (!simulate) {
                    EnergyHost.this.extractLimit.use(this.directionId, transferred);
                }
                return transferred;
            }
            return 0;
        }

        public int extractEnergy(int maxAmount, boolean simulate) {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                if ((maxAmount = EnergyHost.this.insertLimit.limit(this.directionId, maxAmount)) <= 0) {
                    return 0;
                }
                int transferred = ((EnergyCache)node.getNetworkCache()).extract(maxAmount, simulate);
                if (!simulate) {
                    EnergyHost.this.insertLimit.use(this.directionId, transferred);
                }
                return transferred;
            }
            return 0;
        }
    }

    private class ExternalEnergyStorage
    implements IEnergyStorage {
        private final int directionId;
        private final IEnergyStorage delegate;

        private ExternalEnergyStorage(IEnergyStorage delegate, int directionId) {
            this.delegate = delegate;
            this.directionId = directionId;
        }

        public int receiveEnergy(int maxAmount, boolean simulate) {
            if ((maxAmount = EnergyHost.this.insertLimit.limit(this.directionId, maxAmount)) <= 0) {
                return 0;
            }
            int transferred = this.delegate.receiveEnergy(maxAmount, simulate);
            if (!simulate) {
                EnergyHost.this.insertLimit.use(this.directionId, transferred);
            }
            return transferred;
        }

        public int extractEnergy(int maxAmount, boolean simulate) {
            if ((maxAmount = EnergyHost.this.extractLimit.limit(this.directionId, maxAmount)) <= 0) {
                return 0;
            }
            int transferred = this.delegate.extractEnergy(maxAmount, simulate);
            if (!simulate) {
                EnergyHost.this.extractLimit.use(this.directionId, transferred);
            }
            return transferred;
        }

        public int getEnergyStored() {
            return this.delegate.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.delegate.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.delegate.canExtract();
        }

        public boolean canReceive() {
            return this.delegate.canReceive();
        }
    }

    private abstract class AbstractNetworkStorage
    implements IEnergyStorage {
        private AbstractNetworkStorage() {
        }

        public int getEnergyStored() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                return ((EnergyCache)node.getNetworkCache()).getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                return ((EnergyCache)node.getNetworkCache()).getMaxEnergyStored();
            }
            return 0;
        }
    }
}

