/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.model;

import dev.technici4n.moderndynamics.client.model.MdModels;
import dev.technici4n.moderndynamics.client.model.PipeBakedModel;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class PipeUnbakedModel
implements IUnbakedGeometry<PipeUnbakedModel> {
    private final Material baseTexture;
    private final ResourceLocation connector;
    private final ResourceLocation straightLine;
    private final String pipeType;
    private final boolean transparent;
    private final Map<String, ResourceLocation> attachmentModels;

    public PipeUnbakedModel(String pipeType, boolean transparent, Map<String, ResourceLocation> attachmentModels) {
        this.attachmentModels = attachmentModels;
        this.baseTexture = new Material(InventoryMenu.BLOCK_ATLAS, MdId.of("pipe/" + pipeType + "/base"));
        this.connector = MdId.of("pipe/" + pipeType + "/connector");
        this.straightLine = MdId.of("pipe/" + pipeType + "/straight");
        this.pipeType = pipeType;
        this.transparent = transparent;
    }

    public String getPipeType() {
        return this.pipeType;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public static BakedModel[] loadRotatedModels(ResourceLocation modelId, ModelBaker baker) {
        BakedModel[] models = new BakedModel[6];
        for (int i = 0; i < 6; ++i) {
            models[i] = baker.bake(modelId, MdModels.PIPE_BAKE_SETTINGS[i]);
        }
        return models;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> resolver, IGeometryBakingContext context) {
        resolver.apply(this.connector).resolveParents(resolver);
        resolver.apply(this.straightLine).resolveParents(resolver);
        for (ResourceLocation subModel : this.attachmentModels.values()) {
            resolver.apply(subModel).resolveParents(resolver);
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        Map<String, BakedModel[]> bakedAttachments = this.attachmentModels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> PipeUnbakedModel.loadRotatedModels((ResourceLocation)e.getValue(), baker)));
        return new PipeBakedModel(spriteGetter.apply(this.baseTexture), PipeUnbakedModel.loadRotatedModels(this.connector, baker), PipeUnbakedModel.loadRotatedModels(this.straightLine, baker), bakedAttachments, this.transparent);
    }
}

