/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.thirdparty.fabric.MeshBuilderImpl;
import dev.technici4n.moderndynamics.thirdparty.fabric.QuadEmitter;
import dev.technici4n.moderndynamics.util.FluidRenderUtil;
import dev.technici4n.moderndynamics.util.FluidVariant;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class FluidPipeRendering {
    private static final float PIPE_W = 0.375f;
    private static final float P0 = 0.0f;
    private static final float P1 = 0.3125f;
    private static final float P2 = 0.5f;
    private static final float P3 = 0.6875f;
    private static final float P4 = 1.0f;
    public static final int FULL_LIGHT = 0xF000F0;
    private static final int DOWN = 1;
    private static final int UP = 2;
    private static final int NORTH = 4;
    private static final int SOUTH = 8;
    private static final int WEST = 16;
    private static final int EAST = 32;

    public static void drawFluidInPipe(PipeBlockEntity pipe, PoseStack ms, MultiBufferSource vcp, FluidVariant fluid, float fill) {
        int conn = pipe.getClientSideConnections();
        Level level = pipe.getLevel();
        BlockPos pos = pipe.getBlockPos();
        VertexConsumer vc = vcp.getBuffer(RenderType.translucent());
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = FluidRenderUtil.getStillSprite(fluid);
        if (sprite == null || (double)fill < 1.0E-5) {
            return;
        }
        int color = renderProps.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)level, pos);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        MeshBuilderImpl meshBuilder = new MeshBuilderImpl();
        QuadBuilder builder = (direction, x, y, z, X, Y, Z) -> {
            QuadEmitter emitter = meshBuilder.getEmitter();
            FluidPipeRendering.quad(emitter, direction, x, y, z, X, Y, Z);
            emitter.spriteBake(sprite, 4);
            emitter.color(-1, -1, -1, -1);
            vc.putBulkData(ms.last(), emitter.toBakedQuad(sprite), r, g, b, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        };
        float F = fill * 0.375f;
        float E = 0.001f;
        if (FluidPipeRendering.hasConnection(conn, 4)) {
            builder.cube(0.3125f + E, 0.3125f + E, 0.0f, 0.6875f - E, 0.3125f + F - E, 0.3125f + E, 12);
        }
        if (FluidPipeRendering.hasConnection(conn, 8)) {
            builder.cube(0.3125f + E, 0.3125f + E, 0.6875f - E, 0.6875f - E, 0.3125f + F - E, 1.0f, 12);
        }
        if (FluidPipeRendering.hasConnection(conn, 32)) {
            builder.cube(0.6875f - E, 0.3125f + E, 0.3125f + E, 1.0f, 0.3125f + F - E, 0.6875f - E, 48);
        }
        if (FluidPipeRendering.hasConnection(conn, 16)) {
            builder.cube(0.0f, 0.3125f + E, 0.3125f + E, 0.3125f + E, 0.3125f + F - E, 0.6875f - E, 48);
        }
        if (conn == 3) {
            builder.cube(0.5f - F / 2.0f + E, 0.0f, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 1.0f, 0.5f + F / 2.0f - E, 3);
        } else {
            builder.cube(0.3125f + E, 0.3125f + E, 0.3125f + E, 0.6875f - E, 0.3125f + F - E, 0.6875f - E, conn & 0x3C);
            if (FluidPipeRendering.hasConnection(conn, 2)) {
                builder.cube(0.5f - F / 2.0f + E, 0.3125f + F - E, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 1.0f, 0.5f + F / 2.0f - E, 3);
            }
            if (FluidPipeRendering.hasConnection(conn, 1)) {
                builder.cube(0.5f - F / 2.0f + E, 0.0f, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 0.3125f + E, 0.5f + F / 2.0f - E, 3);
            }
        }
    }

    private static boolean hasConnection(int mask, int dir) {
        return (mask & dir) > 0;
    }

    private static void quad(QuadEmitter emitter, Direction direction, float x, float y, float z, float X, float Y, float Z) {
        if (direction == Direction.UP) {
            FluidPipeRendering.quad(emitter, Direction.UP, x, 1.0f - Z, X, 1.0f - z, 1.0f - Y);
        } else if (direction == Direction.DOWN) {
            FluidPipeRendering.quad(emitter, Direction.DOWN, x, z, X, Z, y);
        } else if (direction == Direction.NORTH) {
            FluidPipeRendering.quad(emitter, Direction.NORTH, 1.0f - X, y, 1.0f - x, Y, z);
        } else if (direction == Direction.EAST) {
            FluidPipeRendering.quad(emitter, Direction.EAST, 1.0f - Z, y, 1.0f - z, Y, 1.0f - X);
        } else if (direction == Direction.SOUTH) {
            FluidPipeRendering.quad(emitter, Direction.SOUTH, x, y, X, Y, 1.0f - Z);
        } else {
            FluidPipeRendering.quad(emitter, Direction.WEST, z, y, Z, Y, x);
        }
    }

    protected static void quad(QuadEmitter emitter, Direction direction, float left, float bottom, float right, float top, float depth) {
        emitter.square(direction, left, bottom, right, top, depth);
    }

    private static interface QuadBuilder {
        public void build(Direction var1, float var2, float var3, float var4, float var5, float var6, float var7);

        default public void cube(float x, float y, float z, float X, float Y, float Z, int excludedMask) {
            int mask = 0x3F ^ excludedMask;
            if ((mask & 1) > 0) {
                this.build(Direction.DOWN, x, y, z, X, y, Z);
            }
            if ((mask & 2) > 0) {
                this.build(Direction.UP, x, Y, z, X, Y, Z);
            }
            if ((mask & 4) > 0) {
                this.build(Direction.NORTH, x, y, z, X, Y, z);
            }
            if ((mask & 8) > 0) {
                this.build(Direction.SOUTH, x, y, Z, X, Y, Z);
            }
            if ((mask & 0x20) > 0) {
                this.build(Direction.EAST, X, y, z, X, Y, Z);
            }
            if ((mask & 0x10) > 0) {
                this.build(Direction.WEST, x, y, z, x, Y, Z);
            }
        }
    }
}

