/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.technici4n.moderndynamics.ModernDynamics;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AttachmentUpgradesLoader
extends SimplePreparableReloadListener<List<JsonObject>> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceManager, LoadedUpgrades> LOADED_UPGRADES = new WeakHashMap<ResourceManager, LoadedUpgrades>();

    private AttachmentUpgradesLoader() {
    }

    protected List<JsonObject> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (Map.Entry entry : resourceManager.listResources("attachment_upgrades", s -> s.getPath().endsWith(".json")).entrySet()) {
            Resource resource = (Resource)entry.getValue();
            try {
                InputStream inputStream = resource.open();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    result.add(JsonParser.parseReader((Reader)reader).getAsJsonObject());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (JsonParseException | IOException | IllegalStateException exception) {
                ModernDynamics.LOGGER.error("Error when loading Modern Dynamics attachment upgrade with path %s".formatted(entry.getKey()), exception);
            }
        }
        return result;
    }

    protected void apply(List<JsonObject> array, ResourceManager resourceManager, ProfilerFiller profiler) {
        IdentityHashMap<Item, UpgradeType> map = new IdentityHashMap<Item, UpgradeType>();
        ArrayList<Item> list = new ArrayList<Item>();
        for (JsonObject obj : array) {
            if (!ICondition.conditionsMatched((DynamicOps)JsonOps.INSTANCE, (Object)obj)) continue;
            try {
                Item item = (Item)GsonHelper.getAsItem((JsonObject)obj, (String)"item").value();
                UpgradeType deserialized = (UpgradeType)GSON.fromJson((JsonElement)obj, UpgradeType.class);
                if (!map.containsKey(item)) {
                    list.add(item);
                }
                map.put(item, deserialized);
            }
            catch (Exception exception) {
                ModernDynamics.LOGGER.error("Failed to read attachment upgrade entry " + String.valueOf(obj), (Throwable)exception);
            }
        }
        LOADED_UPGRADES.put(resourceManager, new LoadedUpgrades(map, list));
    }

    public static void setup() {
        NeoForge.EVENT_BUS.addListener(AddReloadListenerEvent.class, e -> e.addListener((PreparableReloadListener)new AttachmentUpgradesLoader()));
        NeoForge.EVENT_BUS.addListener(ServerAboutToStartEvent.class, e -> {
            MinecraftServer server = e.getServer();
            LoadedUpgrades.trySet(LOADED_UPGRADES.remove(server.getResourceManager()));
        });
        NeoForge.EVENT_BUS.addListener(OnDatapackSyncEvent.class, e -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            LoadedUpgrades.trySet(LOADED_UPGRADES.remove(server.getResourceManager()));
            ServerPlayer player = e.getPlayer();
            if (player != null) {
                LoadedUpgrades.syncToClient(player);
            } else {
                LoadedUpgrades.syncToAllClients(e.getPlayerList());
            }
        });
    }
}

