/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import java.util.function.ToIntFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

class UpgradeContainer {
    final NonNullList<ItemStack> upgrades = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    UpgradeContainer() {
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.upgrades, (HolderLookup.Provider)registries);
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.upgrades, (HolderLookup.Provider)registries);
    }

    public boolean mayPlaceUpgrade(int slot, Item upgrade) {
        for (int i = 0; i < 4; ++i) {
            if (i == slot || !((ItemStack)this.upgrades.get(i)).is(upgrade)) continue;
            return false;
        }
        return LoadedUpgrades.getType(upgrade).getSlotLimit() > 0;
    }

    private int reduce(ToIntFunction<UpgradeType> valueExtractor) {
        int tot = 0;
        for (ItemStack stack : this.upgrades) {
            tot += stack.getCount() * valueExtractor.applyAsInt(LoadedUpgrades.getType(stack.getItem()));
        }
        return tot;
    }

    public int getFilterSize() {
        return Mth.clamp((int)(3 + this.reduce(UpgradeType::getAddFilterSlots)), (int)0, (int)15);
    }

    public int getItemsPerOperation() {
        return Mth.clamp((int)(4 + this.reduce(UpgradeType::getAddItemCount)), (int)1, (int)Integer.MAX_VALUE);
    }

    public double getItemSpeedupFactor() {
        return Mth.clamp((double)(1 + this.reduce(UpgradeType::getAddItemSpeed)), (double)0.25, (double)20.0);
    }

    public int getItemOperationTickDelay() {
        return Mth.clamp((int)(40 / (1 + this.reduce(UpgradeType::getAddItemTransferFrequency))), (int)1, (int)200);
    }

    public int getFluidMaxIo() {
        int totalAdd = 1 + this.reduce(UpgradeType::getAddFluidTransfer);
        int totalMultiply = 1 + this.reduce(UpgradeType::getMultiplyFluidTransfer);
        return Mth.clamp((int)(totalAdd * totalMultiply), (int)1, (int)1000000) * 20;
    }

    public boolean isAdvancedBehaviorAllowed() {
        for (ItemStack stack : this.upgrades) {
            if (!LoadedUpgrades.getType(stack.getItem()).isEnableAdvancedBehavior()) continue;
            return true;
        }
        return false;
    }
}

