/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics;

import dev.technici4n.moderndynamics.attachment.upgrade.AttachmentUpgradesLoader;
import dev.technici4n.moderndynamics.client.ModernDynamicsClient;
import dev.technici4n.moderndynamics.init.MdAttachments;
import dev.technici4n.moderndynamics.init.MdBlockEntities;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.init.MdMenus;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.TickHelper;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.packets.MdPackets;
import dev.technici4n.moderndynamics.util.MdItemGroup;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="moderndynamics")
public class ModernDynamics {
    public static final Logger LOGGER = LogManager.getLogger((String)"Modern Dynamics");

    public ModernDynamics(IEventBus modEvents) {
        modEvents.addListener(RegisterEvent.class, this::register);
        modEvents.addListener(RegisterPayloadHandlersEvent.class, this::registerPayloadHandlers);
        modEvents.addListener(MdBlockEntities::registerCapabilities);
        modEvents.addListener(EventPriority.LOW, MdBlockEntities::registerLowPriorityCapabilities);
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, e -> {
            NetworkManager.onServerStopped();
            SimulatedInsertionTargets.clear();
        });
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, e -> {
            TickHelper.onEndTick();
            NetworkManager.onEndTick();
        });
        NeoForge.EVENT_BUS.addListener(WrenchHelper::handleEvent);
        AttachmentUpgradesLoader.setup();
        if (FMLLoader.getDist().isClient()) {
            new ModernDynamicsClient(modEvents);
        }
        LOGGER.info("Successfully loaded Modern Dynamics!");
    }

    private void register(RegisterEvent registerEvent) {
        ResourceKey registryKey = registerEvent.getRegistryKey();
        if (registryKey == Registries.BLOCK) {
            MdBlocks.init();
        } else if (registryKey == Registries.ITEM) {
            MdItems.init();
            MdAttachments.init();
        } else if (registryKey == Registries.BLOCK_ENTITY_TYPE) {
            MdBlockEntities.init();
        } else if (registryKey == Registries.MENU) {
            MdMenus.init();
        } else if (registryKey == Registries.CREATIVE_MODE_TAB) {
            MdItemGroup.init();
        }
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent e) {
        PayloadRegistrar registrar = e.registrar("moderndynamics");
        MdPackets.register(registrar);
    }
}

