/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.ElitePackageRecipeType;
import thelm.packagedexcrafting.recipe.ITablePackageRecipeInfo;

public class ElitePackageRecipeInfo
implements ITablePackageRecipeInfo {
    public static final MapCodec<ElitePackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ElitePackageRecipeInfo::getRecipeId), (App)Codec.INT.fieldOf("width").forGetter(ElitePackageRecipeInfo::getMatrixWidth), (App)Codec.INT.fieldOf("height").forGetter(ElitePackageRecipeInfo::getMatrixHeight), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(49).fieldOf("input").forGetter(ElitePackageRecipeInfo::getMatrixAsList)).apply((Applicative)instance, ElitePackageRecipeInfo::new));
    public static final Codec<ElitePackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, ElitePackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ElitePackageRecipeInfo::getRecipeId, (StreamCodec)ByteBufCodecs.INT, ElitePackageRecipeInfo::getMatrixWidth, (StreamCodec)ByteBufCodecs.INT, ElitePackageRecipeInfo::getMatrixHeight, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, ElitePackageRecipeInfo::getMatrixAsList, ElitePackageRecipeInfo::new);
    private final ResourceLocation id;
    private final ITableRecipe recipe;
    private final List<ItemStack> input;
    private final TableCraftingInput matrix;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public ElitePackageRecipeInfo(ResourceLocation id, int width, int height, List<ItemStack> matrixSer) {
        this.id = id;
        this.matrix = TableCraftingInput.of((int)width, (int)height, matrixSer, (int)3);
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof ITableRecipe) {
            ITableRecipe tableRecipe;
            this.recipe = tableRecipe = (ITableRecipe)recipeSer;
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
    }

    public ElitePackageRecipeInfo(List<ItemStack> inputs, Level level) {
        NonNullList matrixList = NonNullList.withSize((int)49, (Object)ItemStack.EMPTY);
        int[] slotArray = ElitePackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            toSet.setCount(1);
            matrixList.set(i, (Object)toSet.copy());
        }
        this.matrix = TableCraftingInput.of((int)7, (int)7, (List)matrixList, (int)3);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)this.matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (ITableRecipe)recipeHolder.value();
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public IPackageRecipeType getRecipeType() {
        return ElitePackageRecipeType.INSTANCE;
    }

    @Override
    public int getTier() {
        return 3;
    }

    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public ITableRecipe getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public TableCraftingInput getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getMatrixAsList() {
        return Collections.unmodifiableList(this.matrix.items());
    }

    public int getMatrixWidth() {
        return this.matrix.width();
    }

    public int getMatrixHeight() {
        return this.matrix.height();
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.getRemainingItems((RecipeInput)this.matrix);
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = ElitePackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < this.matrix.height(); ++i) {
            for (int j = 0; j < this.matrix.width(); ++j) {
                map.put(slotArray[i * 7 + j], (Object)this.matrix.getItem(i * this.matrix.width() + j));
            }
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElitePackageRecipeInfo) {
            ElitePackageRecipeInfo other = (ElitePackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

