/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedexcrafting.block.entity.AdvancedCrafterBlockEntity;
import thelm.packagedexcrafting.inventory.AdvancedCrafterItemHandlerWrapper;

public class AdvancedCrafterItemHandler
extends BaseItemHandler<AdvancedCrafterBlockEntity> {
    public AdvancedCrafterItemHandler(AdvancedCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 27);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 26) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new AdvancedCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((AdvancedCrafterBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((AdvancedCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((AdvancedCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((AdvancedCrafterBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((AdvancedCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((AdvancedCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

