/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedexcrafting.block.entity.PackagedExCraftingBlockEntities;
import thelm.packagedexcrafting.inventory.MarkedPedestalItemHandler;

public class MarkedPedestalBlockEntity
extends BaseBlockEntity {
    public MarkedPedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedExCraftingBlockEntities.MARKED_PEDESTAL.get(), pos, state);
        this.setItemHandler(new MarkedPedestalItemHandler(this));
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedexcrafting.marked_pedestal");
    }

    public void ejectItem() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            double dx = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.level.random.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + dx, (double)this.worldPosition.getY() + dy, (double)this.worldPosition.getZ() + dz, stack);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    public int getComparatorSignal() {
        return this.itemHandler.getStackInSlot(0).isEmpty() ? 0 : 15;
    }

    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadSync(nbt, registries);
        this.itemHandler.load(nbt, registries);
    }

    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveSync(nbt, registries);
        this.itemHandler.save(nbt, registries);
        return nbt;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return null;
    }
}

