/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.brazier_modding.gdarp.Constants;
import net.brazier_modding.gdarp.config.PackConfig;
import net.brazier_modding.gdarp.pack_dependencies.PackDependency;
import net.brazier_modding.gdarp.pack_finders.GlobalPackFinder;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;

public class CommonClass {
    public static Path GAME_DIR;

    public static Path getGameDir() {
        return GAME_DIR;
    }

    public static RepositorySource getRepositorySource(PackType type, boolean force) {
        ArrayList<Path> files = new ArrayList<Path>();
        List packFolders = switch (type) {
            case PackType.CLIENT_RESOURCES -> {
                if (force) {
                    yield PackConfig.INSTANCE.getRequiredResourcePacks();
                }
                yield PackConfig.INSTANCE.getOptionalResourcePacks();
            }
            case PackType.SERVER_DATA -> {
                if (force) {
                    yield PackConfig.INSTANCE.getRequiredDatapacks();
                }
                yield PackConfig.INSTANCE.getOptionalDatapacks();
            }
            default -> List.of();
        };
        packFolders.stream().map(str -> str.startsWith("/") ? str.substring(1) : str).map(x$0 -> Path.of(x$0, new String[0])).map(path -> PackConfig.INSTANCE.isSystemGlobalPath((Path)path) ? path : GAME_DIR.resolve((Path)path)).forEach(files::add);
        return new GlobalPackFinder(type, force, files);
    }

    static {
        PackDependency.parse("modid");
        PackDependency.parse("m:minecraft@[1.20,1.21)");
        PackDependency.parse("d:datpack");
        PackDependency.parse("r:resourcepack@[1.5.3]");
        GAME_DIR = Path.of(".", new String[0]);
        String launchArgument = System.getProperty("sun.java.command");
        if (launchArgument == null) {
            Constants.LOG.warn("Unable to find launch arguments, the mod might not function as expected.");
        } else if (launchArgument.contains("gameDir")) {
            Pattern pattern = Pattern.compile("gameDir\\s(.+?)(?:\\s--|$)");
            Matcher matcher = pattern.matcher(launchArgument);
            if (!matcher.find()) {
                Constants.LOG.error("Unable to find gameDir in launch arguments '{}' even though it was specified", (Object)"--reducted--");
            } else {
                String gameDirParam = matcher.group(1);
                GAME_DIR = Path.of(gameDirParam, new String[0]);
            }
        }
    }
}

