/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.enums;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ComponentFactory;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum ChannelMode implements ITranslatableEnum<ChannelMode>,
StringRepresentable
{
    PRIORITY("xnetgases.enum.channel_mode.priority"),
    DISTRIBUTE("xnetgases.enum.channel_mode.round_robin");

    public static final Codec<ChannelMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, ChannelMode> STREAM_CODEC;
    private static final Map<String, ChannelMode> NAME_MAP;
    private final String i18n;

    private ChannelMode(String i18n) {
        this.i18n = i18n;
    }

    public static ChannelMode byName(String name) {
        return NAME_MAP.get(name);
    }

    public String getI18n() {
        return ComponentFactory.translatable((String)this.i18n).getString();
    }

    public String[] getI18nSplitedTooltip() {
        return I18nUtils.getSplitedEnumTooltip((String)this.i18n);
    }

    @Nonnull
    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ChannelMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(ChannelMode.class);
        NAME_MAP = Arrays.stream(ChannelMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

